/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.common.ColumnType;
import com.questdb.ex.JournalConfigurationException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.ByteBuffers;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.GenericBinaryBuilder;
import com.questdb.store.factory.configuration.GenericIndexedBuilder;
import com.questdb.store.factory.configuration.GenericStringBuilder;
import com.questdb.store.factory.configuration.GenericSymbolBuilder;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.factory.configuration.MetadataBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JournalStructure
implements MetadataBuilder<Object> {
    private static final Log LOG = LogFactory.getLog(JournalStructure.class);
    private final ObjList<ColumnMetadata> metadata = new ObjList();
    private final CharSequenceIntHashMap nameToIndexMap = new CharSequenceIntHashMap();
    private final String name;
    private int tsColumnIndex = -1;
    private int partitionBy = 3;
    private int recordCountHint = 100000;
    private int txCountHint = -1;
    private String key;
    private long openFileTTL = TimeUnit.MINUTES.toMillis(3L);
    private int lag = -1;
    private Class<Object> modelClass;
    private Constructor<Object> constructor;
    private boolean partialMapping = false;
    private boolean ordered = true;

    public JournalStructure(String name) {
        this.name = name;
    }

    public JournalStructure(String name, ObjList<? extends ColumnMetadata> columnMetadata) {
        this.name = name;
        int sz = columnMetadata.size();
        for (int i = 0; i < sz; ++i) {
            ColumnMetadata to = new ColumnMetadata();
            this.metadata.add(to.copy(columnMetadata.getQuick(i)));
            this.nameToIndexMap.put(to.name, i);
        }
    }

    public JournalStructure(JournalMetadata model) {
        this(model, model.getName());
    }

    public JournalStructure(JournalMetadata model, String name) {
        this.name = name == null ? model.getName() : name;
        this.tsColumnIndex = model.getTimestampIndex();
        this.partitionBy = model.getPartitionBy();
        this.recordCountHint = model.getRecordHint();
        this.txCountHint = model.getTxCountHint();
        this.key = model.getKeyQuiet();
        this.openFileTTL = model.getOpenFileTTL();
        this.lag = model.getLag();
        int n = model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnMetadata to = new ColumnMetadata();
            this.metadata.add(to.copy(model.getColumnQuick(i)));
            this.nameToIndexMap.put(to.name, i);
        }
        this.ordered = model.isOrdered();
    }

    public JournalStructure $() {
        return this;
    }

    public GenericBinaryBuilder $bin(String name) {
        return new GenericBinaryBuilder(this, this.newMeta(name));
    }

    public JournalStructure $bool(String name) {
        return this.$meta(name, 0);
    }

    public JournalStructure $byte(String name) {
        return this.$meta(name, 1);
    }

    public JournalStructure $date(String name) {
        return this.$meta(name, 10);
    }

    public JournalStructure $double(String name) {
        return this.$meta(name, 2);
    }

    public JournalStructure $float(String name) {
        return this.$meta(name, 3);
    }

    public GenericIndexedBuilder $int(String name) {
        return new GenericIndexedBuilder(this, this.newMeta(name), 4, 4);
    }

    public GenericIndexedBuilder $long(String name) {
        return new GenericIndexedBuilder(this, this.newMeta(name), 5, 8);
    }

    public JournalStructure $short(String name) {
        return this.$meta(name, 6);
    }

    public GenericStringBuilder $str(String name) {
        return new GenericStringBuilder(this, this.newMeta(name));
    }

    public GenericSymbolBuilder $sym(String name) {
        return new GenericSymbolBuilder(this, this.newMeta(name));
    }

    public JournalStructure $ts() {
        return this.$ts("timestamp");
    }

    public JournalStructure $ts(int index) {
        this.tsColumnIndex = index;
        return this;
    }

    public JournalStructure $ts(String name) {
        if (this.tsColumnIndex != -1) {
            throw new JournalConfigurationException("Journal can have only one timestamp columns. Use DATE for other columns.");
        }
        this.$meta(name, 10);
        this.tsColumnIndex = this.nameToIndexMap.get(name);
        return this;
    }

    @Override
    public JournalMetadata<Object> build() {
        if (this.txCountHint == -1) {
            this.txCountHint = (int)((double)this.recordCountHint * 0.1);
        }
        ColumnMetadata[] m = new ColumnMetadata[this.metadata.size()];
        int sz = this.metadata.size();
        for (int i = 0; i < sz; ++i) {
            ColumnMetadata meta = this.metadata.getQuick(i);
            if (meta.indexed && meta.distinctCountHint < 2) {
                meta.distinctCountHint = Numbers.ceilPow2(Math.max(2, (int)((double)this.recordCountHint * 0.01))) - 1;
            }
            if (meta.size == 0 && meta.avgSize == 0) {
                throw new JournalConfigurationException("Invalid size for column %s.%s", this.name, meta.name);
            }
            if (meta.distinctCountHint < 1 && meta.type == 8) {
                meta.distinctCountHint = Numbers.ceilPow2((int)((double)this.recordCountHint * 0.2)) - 1;
            }
            switch (meta.type) {
                case 7: {
                    meta.size = meta.avgSize + 4;
                    meta.bitHint = ByteBuffers.getBitHint(meta.avgSize * 2, this.recordCountHint);
                    meta.indexBitHint = ByteBuffers.getBitHint(8, this.recordCountHint);
                    break;
                }
                case 9: {
                    meta.size = meta.avgSize;
                    meta.bitHint = ByteBuffers.getBitHint(meta.avgSize, this.recordCountHint);
                    meta.indexBitHint = ByteBuffers.getBitHint(8, this.recordCountHint);
                    break;
                }
                default: {
                    meta.bitHint = ByteBuffers.getBitHint(meta.size, this.recordCountHint);
                }
            }
            m[i] = meta;
        }
        return new JournalMetadata<Object>(this.name, this.modelClass, this.constructor, this.key, this.partitionBy, m, this.tsColumnIndex, this.openFileTTL, this.recordCountHint, this.txCountHint, this.lag, this.partialMapping, this.ordered);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JournalStructure ordered(boolean flag) {
        this.ordered = flag;
        return this;
    }

    public JournalStructure partitionBy(int partitionBy) {
        if (partitionBy != 4) {
            this.partitionBy = partitionBy;
        }
        return this;
    }

    public JournalStructure recordCountHint(int count) {
        if (count > 0) {
            this.recordCountHint = count;
        }
        return this;
    }

    public int getColumnIndex(CharSequence name) {
        return this.nameToIndexMap.get(name);
    }

    public ColumnMetadata getColumnMetadata(CharSequence name) {
        return this.getColumnMetadata(this.getColumnIndex(name));
    }

    public ColumnMetadata getColumnMetadata(int index) {
        return index == -1 ? null : this.metadata.getQuick(index);
    }

    public boolean hasTimestamp() {
        return this.tsColumnIndex != -1;
    }

    public JournalStructure key(String key) {
        this.key = key;
        return this;
    }

    public JournalStructure lag(long time, TimeUnit unit) {
        this.lag = (int)unit.toHours(time);
        return this;
    }

    public JournalMetadata map(Class clazz) {
        if (clazz != null) {
            List<Field> classFields = this.getAllFields(new ArrayList<Field>(), clazz);
            for (int i = 0; i < classFields.size(); ++i) {
                Field f = classFields.get(i);
                if (Modifier.isStatic(f.getModifiers())) continue;
                int index = this.nameToIndexMap.get(f.getName());
                if (index == -1) {
                    LOG.info().$("Unusable member field: ").$(clazz.getName()).$('.').$(f.getName()).$();
                    continue;
                }
                ColumnMetadata meta = this.metadata.getQuick(index);
                this.checkTypes(meta.type, ColumnType.columnTypeOf(f.getType()));
                meta.offset = Unsafe.getUnsafe().objectFieldOffset(f);
            }
            this.partialMapping = this.missingMappings();
            this.modelClass = clazz;
            try {
                this.constructor = this.modelClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new JournalConfigurationException("No default constructor declared on %s", this.modelClass.getName());
            }
        }
        return this.build();
    }

    public JournalStructure openFileTTL(long time, TimeUnit unit) {
        this.openFileTTL = unit.toMillis(time);
        return this;
    }

    public JournalStructure txCountHint(int count) {
        this.txCountHint = count;
        return this;
    }

    private JournalStructure $meta(String name, int type) {
        ColumnMetadata m = this.newMeta(name);
        m.type = type;
        m.size = ColumnType.sizeOf(type);
        return this;
    }

    private void checkTypes(int expected, int actual) {
        if (expected == actual) {
            return;
        }
        if (expected == 10 && actual == 5) {
            return;
        }
        if (expected == 8 && actual == 7) {
            return;
        }
        throw new JournalConfigurationException("Type mismatch: expected=" + expected + ", actual=" + actual);
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        return type.getSuperclass() != null ? this.getAllFields(fields, type.getSuperclass()) : fields;
    }

    private boolean missingMappings() {
        boolean mappingMissing = false;
        int metadataSize = this.metadata.size();
        for (int i = 0; i < metadataSize; ++i) {
            ColumnMetadata m = this.metadata.getQuick(i);
            if (m.offset != 0L) continue;
            mappingMissing = true;
            LOG.info().$("Unmapped data column: ").$(m.name).$();
        }
        return mappingMissing;
    }

    private ColumnMetadata newMeta(String name) {
        int index = this.nameToIndexMap.get(name);
        if (index == -1) {
            ColumnMetadata meta = new ColumnMetadata().setName(name);
            this.metadata.add(meta);
            this.nameToIndexMap.put(name, this.metadata.size() - 1);
            return meta;
        }
        throw new JournalConfigurationException("Duplicate column: " + name);
    }
}

