/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.std.Numbers;
import com.questdb.store.factory.configuration.AbstractMetadataBuilder;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadataBuilder;

public class StringBuilder<T>
extends AbstractMetadataBuilder<T> {
    public StringBuilder(JournalMetadataBuilder<T> parent, ColumnMetadata meta) {
        super(parent, meta);
        this.size(this.meta.avgSize);
    }

    public StringBuilder<T> buckets(int buckets) {
        this.meta.distinctCountHint = Numbers.ceilPow2(buckets) - 1;
        return this;
    }

    public StringBuilder<T> index() {
        this.meta.indexed = true;
        return this;
    }

    private StringBuilder<T> size(int size) {
        this.meta.avgSize = size;
        this.meta.size = size + 4;
        return this;
    }
}

