/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.factory.configuration;

import com.questdb.ex.JournalConfigurationException;
import com.questdb.std.Numbers;
import com.questdb.store.factory.configuration.AbstractMetadataBuilder;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadataBuilder;

public class SymbolBuilder<T>
extends AbstractMetadataBuilder<T> {
    public SymbolBuilder(JournalMetadataBuilder<T> parent, ColumnMetadata meta) {
        super(parent, meta);
        if (meta.type != 7 && meta.type != 8) {
            throw new JournalConfigurationException("Invalid column type for symbol: %s", meta.name);
        }
        meta.type = 8;
        meta.size = 4;
    }

    public SymbolBuilder<T> index() {
        this.meta.indexed = true;
        return this;
    }

    public SymbolBuilder<T> noCache() {
        this.meta.noCache = true;
        return this;
    }

    public SymbolBuilder<T> sameAs(String name) {
        this.meta.sameAs = name;
        return this;
    }

    public SymbolBuilder<T> size(int size) {
        this.meta.avgSize = size;
        return this;
    }

    public SymbolBuilder<T> valueCountHint(int valueCountHint) {
        this.meta.distinctCountHint = Numbers.ceilPow2(valueCountHint) - 1;
        return this;
    }
}

