/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query;

import com.questdb.std.LongList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.BSearchType;
import com.questdb.store.Journal;
import com.questdb.store.Partition;

public abstract class AbstractResultSetBuilder<T, X> {
    protected final LongList result = new LongList();
    protected Partition<T> partition;
    Journal<T> journal;
    private Interval interval = null;

    AbstractResultSetBuilder(Interval interval) {
        this.interval = interval;
    }

    AbstractResultSetBuilder() {
    }

    public Accept accept(Partition<T> partition) throws JournalException {
        this.partition = partition;
        return Accept.CONTINUE;
    }

    public abstract X getResult();

    public boolean next(Partition<T> partition, boolean desc) throws JournalException {
        Interval that = partition.getInterval();
        if (this.interval != null && that != null && (that.getLo() > this.interval.getHi() || that.getHi() < this.interval.getLo())) {
            return that.getHi() < this.interval.getLo() && !desc || that.getLo() > this.interval.getHi() && desc;
        }
        switch (this.accept(partition)) {
            case SKIP: {
                return false;
            }
            case BREAK: {
                return true;
            }
        }
        long size = partition.open().size();
        if (size > 0L) {
            long lo = 0L;
            long hi = size - 1L;
            if (this.interval != null && partition.getInterval() != null) {
                if (partition.getInterval().getLo() < this.interval.getLo()) {
                    long _lo = partition.indexOf(this.interval.getLo(), BSearchType.NEWER_OR_SAME);
                    if (_lo == -2L) {
                        return false;
                    }
                    lo = _lo;
                }
                if (partition.getInterval().getHi() > this.interval.getHi()) {
                    long _hi = partition.indexOf(this.interval.getHi(), BSearchType.OLDER_OR_SAME);
                    if (_hi == -1L) {
                        return false;
                    }
                    hi = _hi;
                }
            }
            if (lo <= hi) {
                this.read(lo, hi);
            }
        }
        return false;
    }

    public abstract void read(long var1, long var3) throws JournalException;

    public void setJournal(Journal<T> journal) {
        this.journal = journal;
    }

    public static enum Accept {
        CONTINUE,
        SKIP,
        BREAK;

    }
}

