/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query;

import com.questdb.std.LongList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.query.ResultSet;

public class OrderedResultSet<T>
extends ResultSet<T> {
    public OrderedResultSet(Journal<T> journal, LongList rowIDs) {
        super(journal, rowIDs);
    }

    public long getMaxTimestamp() throws JournalException {
        if (this.size() == 0) {
            return 0L;
        }
        long rowID = this.getRowID(this.size() - 1);
        int timestampColumnIndex = this.getJournal().getMetadata().getTimestampIndex();
        return this.getJournal().getPartition(Rows.toPartitionIndex(rowID), true).getLong(Rows.toLocalRowID(rowID), timestampColumnIndex);
    }
}

