/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query;

import com.questdb.std.LongList;
import com.questdb.std.Rnd;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.query.iter.ResultSetBufferedIterator;
import com.questdb.store.query.iter.ResultSetIterator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ResultSet<T>
implements Iterable<T> {
    private final Journal<T> journal;
    private final LongList rowIDs;

    ResultSet(Journal<T> journal, LongList rowIDs) {
        this.journal = journal;
        this.rowIDs = rowIDs;
    }

    public ResultSetBufferedIterator<T> bufferedIterator() {
        return new ResultSetBufferedIterator(this);
    }

    public double getDouble(int rsIndex, int columnIndex) throws JournalException {
        long rowID = this.rowIDs.get(rsIndex);
        return this.journal.getPartition(Rows.toPartitionIndex(rowID), true).getDouble(Rows.toLocalRowID(rowID), columnIndex);
    }

    public long getInt(int rsIndex, int columnIndex) throws JournalException {
        long rowID = this.rowIDs.get(rsIndex);
        return this.journal.getPartition(Rows.toPartitionIndex(rowID), true).getInt(Rows.toLocalRowID(rowID), columnIndex);
    }

    public Journal<T> getJournal() {
        return this.journal;
    }

    public long getLong(int rsIndex, int columnIndex) throws JournalException {
        long rowID = this.rowIDs.get(rsIndex);
        return this.journal.getPartition(Rows.toPartitionIndex(rowID), true).getLong(Rows.toLocalRowID(rowID), columnIndex);
    }

    public long getRowID(int index) {
        return this.rowIDs.get(index);
    }

    public String getString(int rsIndex, int columnIndex) throws JournalException {
        long rowID = this.rowIDs.get(rsIndex);
        return this.journal.getPartition(Rows.toPartitionIndex(rowID), true).getStr(Rows.toLocalRowID(rowID), columnIndex);
    }

    public CharSequence getSymbol(int rsIndex, int columnIndex) throws JournalException {
        long rowID = this.rowIDs.get(rsIndex);
        return this.journal.getPartition(Rows.toPartitionIndex(rowID), true).getSym(Rows.toLocalRowID(rowID), columnIndex);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ResultSetIterator(this);
    }

    public T[] read() throws JournalException {
        return this.journal.read(this.rowIDs);
    }

    public void read(int index, T obj) throws JournalException {
        this.journal.read(this.rowIDs.get(index), obj);
    }

    public T read(int rsIndex) throws JournalException {
        return this.journal.read(this.rowIDs.get(rsIndex));
    }

    public T readFirst() throws JournalException {
        return this.size() > 0 ? (T)this.read(0) : null;
    }

    public T readLast() throws JournalException {
        int size = this.size();
        return size > 0 ? (T)this.read(size - 1) : null;
    }

    public long[] readTimestamps() throws JournalException {
        int timestampColIndex = this.journal.getMetadata().getTimestampIndex();
        long[] result = new long[this.size()];
        int rowIDsLength = this.rowIDs.size();
        for (int i = 0; i < rowIDsLength; ++i) {
            result[i] = this.getLong(i, timestampColIndex);
        }
        return result;
    }

    public ResultSet<T> shuffle(Rnd rnd) {
        LongList rows = new LongList(this.rowIDs);
        rows.shuffle(rnd);
        return new ResultSet<T>(this.journal, rows);
    }

    public int size() {
        return this.rowIDs.size();
    }

    public ResultSet<T> sort(String ... columnNames) throws JournalException {
        return this.sort(Order.ASC, this.getColumnIndexes(columnNames));
    }

    public ResultSet<T> sort(Order order, String ... columnNames) throws JournalException {
        return this.sort(order, this.getColumnIndexes(columnNames));
    }

    public ResultSet<T> sort() {
        this.rowIDs.sort();
        return this;
    }

    public ResultSet<T> subset(int lo, int hi) {
        return new ResultSet<T>(this.journal, this.rowIDs.subset(lo, hi));
    }

    private static <T> int compare(Journal<T> journal, int[] columns, long rightRowID, long leftRowID) throws JournalException {
        int result = 0;
        long leftLocalRowID = Rows.toLocalRowID(leftRowID);
        long rightLocalRowID = Rows.toLocalRowID(rightRowID);
        Partition<T> leftPart = journal.getPartition(Rows.toPartitionIndex(leftRowID), true);
        Partition<T> rightPart = journal.getPartition(Rows.toPartitionIndex(rightRowID), true);
        for (int column : columns) {
            ColumnMetadata meta = journal.getMetadata().getColumnQuick(column);
            block0 : switch (meta.type) {
                case 7: {
                    String leftStr = leftPart.getStr(leftLocalRowID, column);
                    String rightStr = rightPart.getStr(rightLocalRowID, column);
                    if (leftStr == null && rightStr == null) {
                        result = 0;
                        break;
                    }
                    if (leftStr == null) {
                        result = 1;
                        break;
                    }
                    if (rightStr == null) {
                        result = -1;
                        break;
                    }
                    result = rightStr.compareTo(leftStr);
                    break;
                }
                default: {
                    String rightStr;
                    String leftStr;
                    switch (meta.type) {
                        case 4: {
                            result = ResultSet.compare(rightPart.getInt(rightLocalRowID, column), leftPart.getInt(leftLocalRowID, column));
                            break block0;
                        }
                        case 5: 
                        case 10: {
                            result = ResultSet.compare(rightPart.getLong(rightLocalRowID, column), leftPart.getLong(leftLocalRowID, column));
                            break block0;
                        }
                        case 2: {
                            result = ResultSet.compare(rightPart.getDouble(rightLocalRowID, column), leftPart.getDouble(leftLocalRowID, column));
                            break block0;
                        }
                        case 3: {
                            result = ResultSet.compare(rightPart.getFloat(rightLocalRowID, column), leftPart.getFloat(leftLocalRowID, column));
                            break block0;
                        }
                        case 8: {
                            int leftSymIndex = leftPart.getInt(leftLocalRowID, column);
                            int rightSymIndex = rightPart.getInt(rightLocalRowID, column);
                            if (leftSymIndex == -1 && rightSymIndex == -1) {
                                result = 0;
                                break block0;
                            }
                            if (leftSymIndex == -1) {
                                result = 1;
                                break block0;
                            }
                            if (rightSymIndex == -1) {
                                result = -1;
                                break block0;
                            }
                            leftStr = meta.symbolTable.value(leftSymIndex);
                            rightStr = meta.symbolTable.value(rightSymIndex);
                            if (leftStr == null || rightStr == null) {
                                throw new JournalException("Corrupt column [%s] !", meta);
                            }
                            result = rightStr.compareTo(leftStr);
                            break block0;
                        }
                    }
                    throw new JournalException("Unsupported type: " + meta.type, new Object[0]);
                }
            }
            if (result != 0) break;
        }
        return result;
    }

    private static int compare(long a, long b) {
        return Long.compare(a, b);
    }

    private static int compare(int a, int b) {
        return Integer.compare(a, b);
    }

    private static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    private static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    private int[] getColumnIndexes(String ... columnNames) {
        int[] columnIndices = new int[columnNames.length];
        int columnNamesLength = columnNames.length;
        for (int i = 0; i < columnNamesLength; ++i) {
            columnIndices[i] = this.journal.getMetadata().getColumnIndex(columnNames[i]);
        }
        return columnIndices;
    }

    private void quickSort(Order order, int lo, int hi, int ... columnIndices) throws JournalException {
        if (lo >= hi) {
            return;
        }
        int pIndex = lo + (hi - lo) / 2;
        long pivot = this.rowIDs.get(pIndex);
        int multiplier = 1;
        if (order == Order.DESC) {
            multiplier = -1;
        }
        int i = lo;
        int j = hi;
        while (i <= j) {
            while (multiplier * ResultSet.compare(this.journal, columnIndices, this.rowIDs.get(i), pivot) < 0) {
                ++i;
            }
            while (multiplier * ResultSet.compare(this.journal, columnIndices, pivot, this.rowIDs.get(j)) < 0) {
                --j;
            }
            if (i > j) continue;
            long temp = this.rowIDs.get(i);
            this.rowIDs.set(i, this.rowIDs.get(j));
            this.rowIDs.set(j, temp);
            ++i;
            --j;
        }
        this.quickSort(order, lo, j, columnIndices);
        this.quickSort(order, i, hi, columnIndices);
    }

    private ResultSet<T> sort(Order order, int ... columnIndices) throws JournalException {
        int size = this.size();
        if (size > 0) {
            this.quickSort(order, 0, size - 1, columnIndices);
        }
        return this;
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

