/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.query.iter.JournalIteratorRange;
import com.questdb.store.query.iter.JournalPeekingIterator;

public class JournalBufferedIterator<T>
implements JournalPeekingIterator<T>,
ImmutableIterator<T> {
    private final ObjList<JournalIteratorRange> ranges;
    private final Journal<T> journal;
    private final T obj;
    private boolean hasNext = true;
    private int currentIndex = 0;
    private long currentRowID;
    private long currentUpperBound;
    private Partition<T> partition;

    public JournalBufferedIterator(Journal<T> journal, ObjList<JournalIteratorRange> ranges) {
        this.ranges = ranges;
        this.journal = journal;
        this.obj = journal.newObject();
        this.updateVariables();
    }

    @Override
    public Journal<T> getJournal() {
        return this.journal;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        this.partition.read(this.currentRowID, this.obj);
        if (this.currentRowID < this.currentUpperBound) {
            ++this.currentRowID;
        } else {
            ++this.currentIndex;
            this.updateVariables();
        }
        return this.obj;
    }

    @Override
    public boolean isEmpty() {
        return this.ranges == null || this.ranges.size() == 0;
    }

    @Override
    public T peekFirst() {
        JournalIteratorRange w = this.ranges.get(0);
        try {
            this.journal.read(Rows.toRowID(w.partitionID, w.lo), this.obj);
            return this.obj;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Error in iterator at last element", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public T peekLast() {
        JournalIteratorRange w = this.ranges.getLast();
        try {
            this.journal.read(Rows.toRowID(w.partitionID, w.hi), this.obj);
            return this.obj;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Error in iterator at last element", (Throwable)e, new Object[0]);
        }
    }

    private void updateVariables() {
        if (this.currentIndex < this.ranges.size()) {
            JournalIteratorRange w = this.ranges.getQuick(this.currentIndex);
            this.currentRowID = w.lo;
            this.currentUpperBound = w.hi;
            try {
                this.partition = this.journal.getPartition(w.partitionID, true);
            }
            catch (JournalException e) {
                throw new JournalRuntimeException(e);
            }
        } else {
            this.hasNext = false;
        }
    }
}

