/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.SPSequence;
import com.questdb.mp.Sequence;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.NamedDaemonThreadFactory;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.query.iter.ConcurrentIterator;
import com.questdb.store.query.iter.JournalIteratorRange;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JournalConcurrentIterator<T>
implements ObjectFactory<Holder<T>>,
ConcurrentIterator<T>,
ImmutableIterator<T> {
    private final Journal<T> journal;
    private final ObjList<JournalIteratorRange> ranges;
    private final ExecutorService service;
    private RingQueue<Holder<T>> buffer;
    private Sequence pubSeq;
    private Sequence subSeq;
    private int bufferSize;
    private boolean started = false;
    private long cursor = -1L;

    public JournalConcurrentIterator(Journal<T> journal, ObjList<JournalIteratorRange> ranges, int bufferSize) {
        this.bufferSize = bufferSize;
        this.service = Executors.newSingleThreadExecutor(new NamedDaemonThreadFactory("questdb-iterator", false));
        this.journal = journal;
        this.ranges = ranges;
    }

    @Override
    public ConcurrentIterator<T> buffer(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    public void close() {
        this.service.shutdown();
    }

    @Override
    public Journal<T> getJournal() {
        return this.journal;
    }

    @Override
    public boolean hasNext() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
        if (this.cursor >= 0L) {
            this.subSeq.done(this.cursor);
        }
        this.cursor = this.subSeq.nextBully();
        return this.buffer.get((long)this.cursor).hasNext;
    }

    @Override
    public T next() {
        return this.buffer.get((long)this.cursor).object;
    }

    @Override
    public Holder<T> newInstance() {
        Holder h = new Holder();
        h.object = this.getJournal().newObject();
        h.hasNext = true;
        return h;
    }

    private Runnable getRunnable() {
        return new Runnable(){
            boolean hasNext = true;
            private int currentIndex = 0;
            private long currentRowID;
            private long currentUpperBound;
            private int currentPartitionID;

            @Override
            public void run() {
                this.updateVariables();
                try {
                    boolean hadNext;
                    do {
                        long cursor = JournalConcurrentIterator.this.pubSeq.nextBully();
                        Holder holder = (Holder)JournalConcurrentIterator.this.buffer.get(cursor);
                        hadNext = this.hasNext;
                        if (hadNext) {
                            JournalConcurrentIterator.this.journal.read(Rows.toRowID(this.currentPartitionID, this.currentRowID), holder.object);
                            if (this.currentRowID < this.currentUpperBound) {
                                ++this.currentRowID;
                            } else {
                                ++this.currentIndex;
                                this.updateVariables();
                            }
                        }
                        holder.hasNext = hadNext;
                        JournalConcurrentIterator.this.pubSeq.done(cursor);
                    } while (hadNext);
                }
                catch (JournalException e) {
                    throw new JournalRuntimeException("Error in iterator [%s]", (Throwable)e, this);
                }
            }

            private void updateVariables() {
                if (this.currentIndex < JournalConcurrentIterator.this.ranges.size()) {
                    JournalIteratorRange w = (JournalIteratorRange)JournalConcurrentIterator.this.ranges.getQuick(this.currentIndex);
                    this.currentRowID = w.lo;
                    this.currentUpperBound = w.hi;
                    this.currentPartitionID = w.partitionID;
                } else {
                    this.hasNext = false;
                }
            }
        };
    }

    private void start() {
        this.buffer = new RingQueue(this, this.bufferSize);
        this.pubSeq = new SPSequence(this.bufferSize);
        this.subSeq = new SCSequence();
        this.pubSeq.then(this.subSeq).then(this.pubSeq);
        this.service.submit(this.getRunnable());
    }

    protected static final class Holder<T> {
        T object;
        boolean hasNext;

        protected Holder() {
        }
    }
}

