/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.query.iter.JournalIteratorRange;
import com.questdb.store.query.iter.JournalPeekingIterator;

public class JournalIteratorImpl<T>
implements JournalPeekingIterator<T>,
ImmutableIterator<T> {
    private final ObjList<JournalIteratorRange> ranges;
    private final Journal<T> journal;
    private boolean hasNext = true;
    private int currentIndex = 0;
    private long currentRowID;
    private long currentUpperBound;
    private int currentPartitionID;

    public JournalIteratorImpl(Journal<T> journal, ObjList<JournalIteratorRange> ranges) {
        this.ranges = ranges;
        this.journal = journal;
        this.updateVariables();
        this.hasNext = this.hasNext && this.currentRowID <= this.currentUpperBound;
    }

    @Override
    public Journal<T> getJournal() {
        return this.journal;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        try {
            T result = this.journal.read(Rows.toRowID(this.currentPartitionID, this.currentRowID));
            if (this.currentRowID < this.currentUpperBound) {
                ++this.currentRowID;
            } else {
                ++this.currentIndex;
                this.updateVariables();
            }
            return result;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Error in iterator [%s]", (Throwable)e, this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.ranges == null || this.ranges.size() == 0;
    }

    @Override
    public T peekFirst() {
        JournalIteratorRange w = this.ranges.get(0);
        try {
            return this.journal.read(Rows.toRowID(w.partitionID, w.lo));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Error in iterator at first element", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public T peekLast() {
        JournalIteratorRange w = this.ranges.getLast();
        try {
            return this.journal.read(Rows.toRowID(w.partitionID, w.hi));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Error in iterator at last element", (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        return "JournalIteratorImpl{currentRowID=" + this.currentRowID + ", currentUpperBound=" + this.currentUpperBound + ", currentPartitionID=" + this.currentPartitionID + ", currentIndex=" + this.currentIndex + ", journal=" + this.journal + '}';
    }

    private void updateVariables() {
        if (this.currentIndex < this.ranges.size()) {
            JournalIteratorRange w = this.ranges.getQuick(this.currentIndex);
            this.currentRowID = w.lo;
            this.currentUpperBound = w.hi;
            this.currentPartitionID = w.partitionID;
        } else {
            this.hasNext = false;
        }
    }
}

