/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.std.ImmutableIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MergingIterator<T>
implements ImmutableIterator<T> {
    Iterator<T> a;
    Iterator<T> b;
    Comparator<T> comparator;
    T nextA;
    T nextB;

    public static <T, X extends ImmutableIterator<T>> ImmutableIterator<T> merge(List<X> iterators, Comparator<T> comparator) {
        return MergingIterator.merge(iterators, comparator, 0);
    }

    public MergingIterator<T> $new(Iterator<T> a, Iterator<T> b, Comparator<T> comparator) {
        this.a = a;
        this.b = b;
        this.comparator = comparator;
        this.nextA = null;
        this.nextB = null;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextA != null || this.a.hasNext() || this.nextB != null || this.b.hasNext();
    }

    @Override
    public T next() {
        T result;
        if (this.nextA == null && this.a.hasNext()) {
            this.nextA = this.a.next();
        }
        if (this.nextB == null && this.b.hasNext()) {
            this.nextB = this.b.next();
        }
        if (this.nextB == null || this.nextA != null && this.comparator.compare(this.nextA, this.nextB) < 0) {
            result = this.nextA;
            this.nextA = null;
        } else {
            result = this.nextB;
            this.nextB = null;
        }
        return result;
    }

    private static <T, X extends ImmutableIterator<T>> ImmutableIterator<T> merge(List<X> iterators, Comparator<T> comparator, int index) {
        if (iterators == null || iterators.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (iterators.size() - index == 1) {
            return (ImmutableIterator)iterators.get(index);
        }
        return new MergingIterator<T>().$new((Iterator)iterators.get(index), MergingIterator.merge(iterators, comparator, index + 1), comparator);
    }
}

