/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.store.query.iter.PeekingIterator;

public class PartitionBufferedIterator<T>
implements JournalIterator<T>,
PeekingIterator<T>,
ImmutableIterator<T> {
    private final long hi;
    private final long lo;
    private final T obj;
    private final Partition<T> partition;
    private long cursor;

    public PartitionBufferedIterator(Partition<T> partition, long lo, long hi) {
        this.lo = lo;
        this.cursor = lo;
        this.hi = hi;
        this.obj = partition.getJournal().newObject();
        this.partition = partition;
    }

    @Override
    public Journal<T> getJournal() {
        return this.partition.getJournal();
    }

    @Override
    public boolean hasNext() {
        return this.cursor <= this.hi;
    }

    @Override
    public T next() {
        return this.get(this.cursor++);
    }

    @Override
    public boolean isEmpty() {
        return this.cursor > this.hi;
    }

    @Override
    public T peekFirst() {
        return this.get(this.lo);
    }

    @Override
    public T peekLast() {
        return this.get(this.hi);
    }

    private T get(long localRowID) {
        try {
            if (!this.partition.isOpen()) {
                this.partition.open();
            }
            this.partition.read(localRowID, this.obj);
            return this.obj;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Cannot read partition " + this.partition + " at " + localRowID, (Throwable)e, new Object[0]);
        }
    }
}

