/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.query.ResultSet;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.store.query.iter.PeekingIterator;

public class ResultSetBufferedIterator<T>
implements JournalIterator<T>,
PeekingIterator<T>,
ImmutableIterator<T> {
    private final ResultSet<T> rs;
    private final T obj;
    private int cursor = 0;

    public ResultSetBufferedIterator(ResultSet<T> rs) {
        this.rs = rs;
        this.obj = rs.getJournal().newObject();
    }

    @Override
    public Journal<T> getJournal() {
        return this.rs.getJournal();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rs.size();
    }

    @Override
    public T next() {
        return this.get(this.cursor++);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T peekFirst() {
        return this.get(0);
    }

    @Override
    public T peekLast() {
        return this.get(this.rs.size() - 1);
    }

    private T get(int rsIndex) {
        try {
            this.rs.read(rsIndex, this.obj);
            return this.obj;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Journal exception at [" + rsIndex + ']', (Throwable)e, new Object[0]);
        }
    }
}

