/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.iter;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.query.ResultSet;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.store.query.iter.PeekingIterator;

public class ResultSetIterator<T>
implements JournalIterator<T>,
PeekingIterator<T>,
ImmutableIterator<T> {
    private final ResultSet<T> rs;
    private int cursor = 0;

    public ResultSetIterator(ResultSet<T> rs) {
        this.rs = rs;
    }

    @Override
    public Journal<T> getJournal() {
        return this.rs.getJournal();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.rs.size();
    }

    @Override
    public T next() {
        try {
            return this.rs.read(this.cursor++);
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Journal exception", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cursor >= this.rs.size();
    }

    @Override
    public T peekFirst() {
        try {
            return this.rs.readFirst();
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Journal exception", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public T peekLast() {
        try {
            return this.rs.readLast();
        }
        catch (JournalException e) {
            throw new JournalRuntimeException("Journal exception", (Throwable)e, new Object[0]);
        }
    }
}

