/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.spi;

import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.Journal;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.query.UnorderedResultSet;
import com.questdb.store.query.api.QueryAllBuilder;
import com.questdb.store.query.spi.QueryAllResultSetBuilder;

public class QueryAllBuilderImpl<T>
implements QueryAllBuilder<T> {
    private final Journal<T> journal;
    private final IntList symbolKeys = new IntList();
    private final ObjList<String> filterSymbols = new ObjList();
    private final IntList filterSymbolKeys = new IntList();
    private String symbol;
    private Interval interval;

    public QueryAllBuilderImpl(Journal<T> journal) {
        this.journal = journal;
    }

    @Override
    public UnorderedResultSet<T> asResultSet() throws JournalException {
        return (UnorderedResultSet)this.journal.iteratePartitionsDesc(new QueryAllResultSetBuilder(this.interval, this.symbol, this.symbolKeys, this.filterSymbols, this.filterSymbolKeys));
    }

    @Override
    public QueryAllBuilder<T> filter(String symbol, CharSequence value) {
        MMappedSymbolTable tab = this.journal.getSymbolTable(symbol);
        int key = tab.get(value);
        this.filterSymbols.add(symbol);
        this.filterSymbolKeys.add(key);
        return this;
    }

    @Override
    public void resetFilter() {
        this.filterSymbols.clear();
        this.filterSymbolKeys.clear();
    }

    @Override
    public QueryAllBuilder<T> slice(Interval interval) {
        this.setInterval(interval);
        return this;
    }

    public void setSymbol(String symbol, String ... values) {
        this.symbol = symbol;
        MMappedSymbolTable symbolTable = this.journal.getSymbolTable(symbol);
        this.symbolKeys.clear();
        for (int i = 0; i < values.length; ++i) {
            int key = symbolTable.getQuick(values[i]);
            if (key == -2) continue;
            this.symbolKeys.add(key);
        }
    }

    private void setInterval(Interval interval) {
        this.interval = interval;
    }
}

