/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.spi;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.query.OrderedResultSet;
import com.questdb.store.query.OrderedResultSetBuilder;
import com.questdb.store.query.api.QueryAll;
import com.questdb.store.query.api.QueryAllBuilder;
import com.questdb.store.query.iter.JournalBufferedIterator;
import com.questdb.store.query.iter.JournalConcurrentIterator;
import com.questdb.store.query.iter.JournalIterator;
import com.questdb.store.query.iter.JournalIteratorImpl;
import com.questdb.store.query.iter.JournalIteratorRange;
import com.questdb.store.query.iter.JournalPeekingIterator;
import com.questdb.store.query.spi.QueryAllBuilderImpl;
import java.util.Iterator;

public class QueryAllImpl<T>
implements QueryAll<T> {
    private final Journal<T> journal;

    public QueryAllImpl(Journal<T> journal) {
        this.journal = journal;
    }

    @Override
    public OrderedResultSet<T> asResultSet() throws JournalException {
        return (OrderedResultSet)this.journal.iteratePartitions(new OrderedResultSetBuilder<T>(){

            @Override
            public void read(long lo, long hi) throws JournalException {
                this.result.ensureCapacity((int)(hi - lo + 1L));
                for (long i = lo; i < hi + 1L; ++i) {
                    this.result.add(Rows.toRowID(this.partition.getPartitionIndex(), i));
                }
            }
        });
    }

    @Override
    public JournalPeekingIterator<T> bufferedIterator() {
        return new JournalBufferedIterator<T>(this.journal, this.createRanges());
    }

    @Override
    public JournalPeekingIterator<T> bufferedIterator(Interval interval) {
        return new JournalBufferedIterator<T>(this.journal, this.createRanges(interval));
    }

    @Override
    public JournalPeekingIterator<T> bufferedIterator(long rowid) {
        return new JournalBufferedIterator<T>(this.journal, this.createRanges(rowid));
    }

    @Override
    public JournalConcurrentIterator<T> concurrentIterator() {
        return new JournalConcurrentIterator<T>(this.journal, this.createRanges(), 1024);
    }

    @Override
    public JournalConcurrentIterator<T> concurrentIterator(Interval interval) {
        return new JournalConcurrentIterator<T>(this.journal, this.createRanges(interval), 1024);
    }

    @Override
    public JournalConcurrentIterator<T> concurrentIterator(long rowid) {
        return new JournalConcurrentIterator<T>(this.journal, this.createRanges(rowid), 1024);
    }

    @Override
    public JournalPeekingIterator<T> incrementBufferedIterator() {
        try {
            long lo = this.journal.getMaxRowID();
            this.journal.refresh();
            return new JournalBufferedIterator<T>(this.journal, this.createRanges(this.journal.incrementRowID(lo)));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public JournalPeekingIterator<T> incrementIterator() {
        try {
            long lo = this.journal.getMaxRowID();
            this.journal.refresh();
            return new JournalIteratorImpl<T>(this.journal, this.createRanges(this.journal.incrementRowID(lo)));
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public JournalIterator<T> iterator(Interval interval) {
        return new JournalIteratorImpl<T>(this.journal, this.createRanges(interval));
    }

    @Override
    public JournalPeekingIterator<T> iterator(long rowid) {
        return new JournalIteratorImpl<T>(this.journal, this.createRanges(rowid));
    }

    @Override
    public long size() {
        try {
            return this.journal.size();
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }

    @Override
    public QueryAllBuilder<T> withKeys(String ... values) {
        return this.withSymValues(this.journal.getMetadata().getKeyColumn(), values);
    }

    @Override
    public QueryAllBuilder<T> withSymValues(String symbol, String ... values) {
        QueryAllBuilderImpl<T> result = new QueryAllBuilderImpl<T>(this.journal);
        result.setSymbol(symbol, values);
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new JournalIteratorImpl<T>(this.journal, this.createRanges());
    }

    private ObjList<JournalIteratorRange> createRanges() {
        int partitionCount = this.journal.getPartitionCount();
        ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>(partitionCount);
        try {
            for (int i = 0; i < partitionCount; ++i) {
                Partition<T> p = this.journal.getPartition(i, true);
                long size = p.size();
                if (size <= 0L) continue;
                ranges.add(new JournalIteratorRange(p.getPartitionIndex(), 0L, size - 1L));
            }
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return ranges;
    }

    private ObjList<JournalIteratorRange> createRanges(Interval interval) {
        final ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>();
        try {
            this.journal.iteratePartitions(new OrderedResultSetBuilder<T>(interval){

                @Override
                public void read(long lo, long hi) throws JournalException {
                    ranges.add(new JournalIteratorRange(this.partition.getPartitionIndex(), lo, hi));
                }
            });
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
        return ranges;
    }

    private ObjList<JournalIteratorRange> createRanges(long lo) {
        ObjList<JournalIteratorRange> ranges = new ObjList<JournalIteratorRange>();
        int loPartitionID = Rows.toPartitionIndex(lo);
        long loLocalRowID = Rows.toLocalRowID(lo);
        try {
            int count = this.journal.getPartitionCount();
            for (int i = loPartitionID; i < count; ++i) {
                Partition<T> p;
                long size;
                long localRowID = 0L;
                if (i == loPartitionID) {
                    localRowID = loLocalRowID;
                }
                if ((size = (p = this.journal.getPartition(i, true)).size()) <= 0L) continue;
                ranges.add(new JournalIteratorRange(p.getPartitionIndex(), localRowID, size - 1L));
            }
            return ranges;
        }
        catch (JournalException e) {
            throw new JournalRuntimeException(e);
        }
    }
}

