/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.spi;

import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.store.Partition;
import com.questdb.store.query.AbstractResultSetBuilder;
import com.questdb.store.query.UnorderedResultSetBuilder;

public class QueryAllResultSetBuilder<T>
extends UnorderedResultSetBuilder<T> {
    private final IntList symbolKeys;
    private final ObjList<String> filterSymbols;
    private final IntList filterSymbolKeys;
    private final String symbol;
    private KVIndex index;
    private KVIndex[] searchIndices;

    public QueryAllResultSetBuilder(Interval interval, String symbol, IntList symbolKeys, ObjList<String> filterSymbols, IntList filterSymbolKeys) {
        super(interval);
        this.symbol = symbol;
        this.symbolKeys = symbolKeys;
        this.filterSymbols = filterSymbols;
        this.filterSymbolKeys = filterSymbolKeys;
    }

    @Override
    public AbstractResultSetBuilder.Accept accept(Partition<T> partition) throws JournalException {
        super.accept(partition);
        this.index = partition.open().getIndexForColumn(this.symbol);
        if (this.symbolKeys.size() > 0) {
            int sz = this.symbolKeys.size();
            for (int i = 0; i < sz; ++i) {
                if (!this.index.contains(this.symbolKeys.getQuick(i))) continue;
                int n = this.filterSymbols.size();
                this.searchIndices = new KVIndex[n];
                for (int k = 0; k < n; ++k) {
                    this.searchIndices[k] = partition.getIndexForColumn(this.filterSymbols.getQuick(k));
                }
                return AbstractResultSetBuilder.Accept.CONTINUE;
            }
            return AbstractResultSetBuilder.Accept.SKIP;
        }
        return AbstractResultSetBuilder.Accept.BREAK;
    }

    @Override
    public void read(long lo, long hi) {
        int sz = this.symbolKeys.size();
        for (int i = 0; i < sz; ++i) {
            int symbolKey = this.symbolKeys.getQuick(i);
            if (!this.index.contains(symbolKey)) continue;
            if (this.searchIndices.length > 0) {
                for (int k = 0; k < this.searchIndices.length; ++k) {
                    long localRowID;
                    if (!this.searchIndices[k].contains(this.filterSymbolKeys.getQuick(k))) continue;
                    LongList searchLocalRowIDs = this.searchIndices[k].getValues(this.filterSymbolKeys.getQuick(k));
                    IndexCursor cursor = this.index.cursor(symbolKey);
                    while (cursor.hasNext() && (localRowID = cursor.next()) >= lo) {
                        if (localRowID > hi || searchLocalRowIDs.binarySearch(localRowID) < 0) continue;
                        this.result.add(Rows.toRowID(this.partition.getPartitionIndex(), localRowID));
                    }
                }
                continue;
            }
            IndexCursor cursor = this.index.cursor(symbolKey);
            this.result.ensureCapacity((int)cursor.size());
            while (cursor.hasNext()) {
                long localRowID = cursor.next();
                if (localRowID < lo || localRowID > hi) continue;
                this.result.add(Rows.toRowID(this.partition.getPartitionIndex(), localRowID));
            }
        }
    }
}

