/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.query.spi;

import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.Interval;
import com.questdb.store.IndexCursor;
import com.questdb.store.Journal;
import com.questdb.store.KVIndex;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.Partition;
import com.questdb.store.query.AbstractResultSetBuilder;
import com.questdb.store.query.UnorderedResultSet;
import com.questdb.store.query.UnorderedResultSetBuilder;
import com.questdb.store.query.api.QueryHeadBuilder;

public class QueryHeadBuilderImpl<T>
implements QueryHeadBuilder<T> {
    private final Journal<T> journal;
    private final IntList symbolKeys = new IntList();
    private final IntList zone1Keys = new IntList();
    private final IntList zone2Keys = new IntList();
    private final ObjList<String> filterSymbols = new ObjList();
    private final IntList filterSymbolKeys = new IntList();
    private int symbolColumnIndex;
    private Interval interval;
    private long minRowID = -1L;
    private boolean strict = true;

    public QueryHeadBuilderImpl(Journal<T> journal) {
        this.journal = journal;
    }

    @Override
    public UnorderedResultSet<T> asResultSet() throws JournalException {
        long minLocalRowID;
        int minPartitionIndex;
        if (this.minRowID == -1L) {
            minPartitionIndex = 0;
            minLocalRowID = -1L;
        } else {
            minPartitionIndex = Rows.toPartitionIndex(this.minRowID);
            minLocalRowID = Rows.toLocalRowID(this.minRowID);
        }
        this.zone1Keys.clear(this.symbolKeys.size());
        this.zone2Keys.clear(this.symbolKeys.size());
        this.zone1Keys.addAll(this.symbolKeys);
        return (UnorderedResultSet)this.journal.iteratePartitionsDesc(new UnorderedResultSetBuilder<T>(this.interval){
            private final KVIndex[] filterKVIndexes;
            private final LongList[] filterSymbolRows;
            private IntList keys;
            private IntList remainingKeys;
            {
                super(interval);
                this.filterKVIndexes = new KVIndex[QueryHeadBuilderImpl.this.filterSymbolKeys.size()];
                this.filterSymbolRows = new LongList[QueryHeadBuilderImpl.this.filterSymbolKeys.size()];
                this.keys = QueryHeadBuilderImpl.this.zone1Keys;
                this.remainingKeys = QueryHeadBuilderImpl.this.zone2Keys;
                for (int i = 0; i < this.filterSymbolRows.length; ++i) {
                    this.filterSymbolRows[i] = new LongList();
                }
            }

            @Override
            public AbstractResultSetBuilder.Accept accept(Partition<T> partition) throws JournalException {
                super.accept(partition);
                return this.keys.size() == 0 || partition.getPartitionIndex() < minPartitionIndex ? AbstractResultSetBuilder.Accept.BREAK : AbstractResultSetBuilder.Accept.CONTINUE;
            }

            @Override
            public void read(long lo, long hi) throws JournalException {
                KVIndex index = this.partition.getIndexForColumn(QueryHeadBuilderImpl.this.symbolColumnIndex);
                boolean filterOk = true;
                for (int i = 0; i < QueryHeadBuilderImpl.this.filterSymbols.size(); ++i) {
                    this.filterKVIndexes[i] = this.partition.getIndexForColumn((String)QueryHeadBuilderImpl.this.filterSymbols.getQuick(i));
                    int filterKey = QueryHeadBuilderImpl.this.filterSymbolKeys.getQuick(i);
                    if (!this.filterKVIndexes[i].contains(filterKey)) {
                        filterOk = false;
                        break;
                    }
                    this.filterSymbolRows[i].ensureCapacity(this.filterKVIndexes[i].getValueCount(filterKey));
                    this.filterKVIndexes[i].getValues(filterKey, this.filterSymbolRows[i]);
                }
                if (filterOk) {
                    for (int k = 0; k < this.keys.size(); ++k) {
                        int key = this.keys.getQuick(k);
                        boolean found = false;
                        IndexCursor cursor = index.cursor(key);
                        block2: while (cursor.hasNext()) {
                            long localRowID = cursor.next();
                            if (localRowID <= hi && localRowID >= lo && (this.partition.getPartitionIndex() > minPartitionIndex || localRowID > minLocalRowID)) {
                                boolean matches = true;
                                for (int i = 0; i < this.filterSymbolRows.length; ++i) {
                                    if (this.filterSymbolRows[i].binarySearch(localRowID) >= 0) continue;
                                    matches = false;
                                    if (!QueryHeadBuilderImpl.this.strict) break;
                                    found = true;
                                    break block2;
                                }
                                if (!matches) continue;
                                this.result.add(Rows.toRowID(this.partition.getPartitionIndex(), localRowID));
                                found = true;
                                break;
                            }
                            if (localRowID >= lo && (this.partition.getPartitionIndex() > minPartitionIndex || localRowID > minLocalRowID)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.remainingKeys.add(key);
                    }
                    IntList temp = this.keys;
                    this.keys = this.remainingKeys;
                    this.remainingKeys = temp;
                    this.remainingKeys.clear();
                }
            }
        });
    }

    @Override
    public QueryHeadBuilder<T> filter(String symbol, String value) {
        MMappedSymbolTable tab = this.journal.getSymbolTable(symbol);
        int key = tab.get(value);
        this.filterSymbols.add(symbol);
        this.filterSymbolKeys.add(key);
        return this;
    }

    @Override
    public QueryHeadBuilder<T> limit(Interval interval) {
        this.interval = interval;
        this.minRowID = -1L;
        return this;
    }

    @Override
    public QueryHeadBuilder<T> limit(long minRowID) {
        this.minRowID = minRowID;
        this.interval = null;
        return this;
    }

    @Override
    public void resetFilter() {
        this.filterSymbols.clear();
        this.filterSymbolKeys.clear();
    }

    @Override
    public QueryHeadBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public void setSymbol(String symbol, String ... values) {
        this.symbolColumnIndex = this.journal.getMetadata().getColumnIndex(symbol);
        MMappedSymbolTable symbolTable = this.journal.getSymbolTable(symbol);
        this.symbolKeys.clear(values == null || values.length == 0 ? symbolTable.size() : values.length);
        if (values == null || values.length == 0) {
            int sz = symbolTable.size();
            for (int i = 0; i < sz; ++i) {
                this.symbolKeys.add(i);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                int key = symbolTable.getQuick(values[i]);
                if (key == -2) continue;
                this.symbolKeys.add(key);
            }
        }
    }
}

