/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.util;

import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.FileSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.File;
import java.io.IOException;

public final class ExportManager {
    private ExportManager() {
    }

    public static void export(RecordSource from, ReaderFactory factory, File to, char delimiter) throws JournalException, IOException {
        if (to.isDirectory()) {
            throw new JournalException(to + "cannot be a directory", new Object[0]);
        }
        try (FileSink sink = new FileSink(to);){
            RecordSourcePrinter printer = new RecordSourcePrinter(sink, delimiter);
            printer.print(from, factory, true);
        }
    }
}

