/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.store.util;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.common.JournalRuntimeException;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.JsonSchemaParser;
import com.questdb.parser.json.JsonException;
import com.questdb.parser.json.JsonLexer;
import com.questdb.parser.plaintext.MetadataAwareTextParser;
import com.questdb.parser.plaintext.PlainTextLexer;
import com.questdb.parser.plaintext.PlainTextParser;
import com.questdb.parser.plaintext.PlainTextStoringParser;
import com.questdb.parser.typeprobe.TypeProbeCollection;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.std.time.TimeZoneRuleFactory;
import com.questdb.store.factory.Factory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.Nullable;

public final class ImportManager {
    private static final int SAMPLE_SIZE = 100;

    private ImportManager() {
    }

    public static void importFile(Factory factory, String fileName, char delimiter, @Nullable CharSequence schema, boolean forceHeader) throws IOException {
        ImportManager.importFile(factory, fileName, delimiter, schema, 100, forceHeader);
    }

    public static void importFile(Factory factory, String fileName, char delimiter, CharSequence schema, int sampleSize, boolean forceHeader) throws IOException {
        BootstrapEnv env = new BootstrapEnv();
        env.typeProbeCollection = new TypeProbeCollection();
        env.configuration = new ServerConfiguration();
        env.factory = factory;
        try (PlainTextLexer parser = new PlainTextLexer(env).of(delimiter);){
            File file = new File(fileName);
            String location = file.getName();
            switch (factory.getConfiguration().exists(location)) {
                case 4: {
                    throw new JournalRuntimeException("A foreign file/directory already exists: " + new File(factory.getConfiguration().getJournalBase(), location), new Object[0]);
                }
            }
            try (PlainTextStoringParser l = new PlainTextStoringParser(env).of(location, false, false, 1);){
                ImportManager.analyzeAndParse(file, parser, l, schema, sampleSize, forceHeader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(File file, PlainTextLexer parser, long bufSize, boolean header, PlainTextParser plainTextParser) throws IOException {
        parser.clear();
        parser.setHeader(header);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");
             FileChannel channel = raf.getChannel();){
            long size = channel.size();
            long bufSz = bufSize == -1L ? ByteBuffers.getMaxMappedBufferSize(size) : bufSize;
            long p = 0L;
            while (p < size) {
                MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, p, size - p < bufSz ? size - p : bufSz);
                try {
                    p += (long)buf.remaining();
                    parser.parse(ByteBuffers.getAddress(buf), buf.remaining(), Integer.MAX_VALUE, plainTextParser);
                }
                finally {
                    ByteBuffers.release(buf);
                }
            }
            parser.parseLast();
            plainTextParser.onLineCount(parser.getLineCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyzeAndParse(File file, PlainTextLexer parser, MetadataAwareTextParser listener, CharSequence schema, int sampleSize, boolean forceHeader) throws IOException {
        parser.clear();
        ObjList<ImportedColumnMetadata> metadata = null;
        if (schema != null) {
            BootstrapEnv env = new BootstrapEnv();
            env.dateLocaleFactory = new DateLocaleFactory(new TimeZoneRuleFactory());
            env.dateFormatFactory = new DateFormatFactory();
            JsonSchemaParser jsonSchemaParser = new JsonSchemaParser(env);
            int len = schema.length();
            long addr = Unsafe.malloc(len);
            try {
                Chars.strcpy(schema, len, addr);
                try (JsonLexer lexer = new JsonLexer(1024);){
                    lexer.parse(addr, len, jsonSchemaParser);
                    lexer.parseLast();
                }
                metadata = jsonSchemaParser.getMetadata();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
            finally {
                Unsafe.free(addr, len);
            }
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");
             FileChannel channel = raf.getChannel();){
            long size = channel.size();
            long bufSize = ByteBuffers.getMaxMappedBufferSize(size);
            long p = 0L;
            while (p < size) {
                MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, p, size - p < bufSize ? size - p : bufSize);
                try {
                    if (p == 0L) {
                        parser.analyseStructure(ByteBuffers.getAddress(buf), buf.remaining(), sampleSize, listener, forceHeader, metadata);
                    }
                    p += (long)buf.remaining();
                    parser.parse(ByteBuffers.getAddress(buf), buf.remaining(), Integer.MAX_VALUE, listener);
                }
                finally {
                    ByteBuffers.release(buf);
                }
            }
            parser.parseLast();
        }
    }
}

