/*******************************************************************************
 *    ___                  _   ____  ____
 *   / _ \ _   _  ___  ___| |_|  _ \| __ )
 *  | | | | | | |/ _ \/ __| __| | | |  _ \
 *  | |_| | |_| |  __/\__ \ |_| |_| | |_) |
 *   \__\_\\__,_|\___||___/\__|____/|____/
 *
 * Copyright (C) 2014-2017 Appsicle
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

package com.questdb.common;

public interface RecordMetadata {

    String getAlias();

    void setAlias(String alias);

    RecordColumnMetadata getColumn(CharSequence name);

    int getColumnCount();

    /**
     * Finds index of column by given name. If name is invalid a JournalRuntimeException is thrown.
     *
     * @param name column name
     * @return column index between 0 and getColumnCount()-1
     */
    int getColumnIndex(CharSequence name);

    int getColumnIndexQuiet(CharSequence name);

    String getColumnName(int index);

    /**
     * Finds column metadata by column index. Method does not perform boundary checks, relying on caller to do so.
     *
     * @param index must be &gt;=0 and &lt; getColumnCount()
     * @return column metadata
     */
    RecordColumnMetadata getColumnQuick(int index);

    int getTimestampIndex();
}
