package com.questdb.ql;

import org.junit.Test;

public class RoundFunctionsTest extends AbstractAllTypeTest {
    @Test
    public void testRoundDown() throws Exception {
        assertThat("1.050231933594\t1.050200000000\n" +
                        "566.734375000000\t566.734300000000\n" +
                        "0.000013792171\t0.000000000000\n" +
                        "0.000000567185\t0.000000000000\n" +
                        "-512.000000000000\t-512.000000000000\n" +
                        "0.675451681018\t0.675400000000\n" +
                        "0.332301996648\t0.332300000000\n" +
                        "0.000001752813\t0.000000000000\n" +
                        "0.000076281818\t0.000000000000\n" +
                        "0.000000005555\t0.000000000000\n" +
                        "0.000002473130\t0.000000000000\n" +
                        "632.921875000000\t632.921800000000\n" +
                        "0.000000020896\t0.000000000000\n" +
                        "0.007371325744\t0.007300000000\n" +
                        "0.000000014643\t0.000000000000\n" +
                        "512.000000000000\t512.000000000000\n" +
                        "864.000000000000\t864.000000000000\n" +
                        "0.000000157437\t0.000000000000\n" +
                        "-842.000000000000\t-842.000000000000\n" +
                        "0.000032060649\t0.000000000000\n",
                "select d, roundDown(d, 4) from abc");
    }

    @Test
    public void testRoundHalfDown() throws Exception {
        assertThat("1.050231933594\t1.050200000000\n" +
                        "566.734375000000\t566.734400000000\n" +
                        "0.000013792171\t0.000000000000\n" +
                        "0.000000567185\t0.000000000000\n" +
                        "-512.000000000000\t-512.000000000000\n" +
                        "0.675451681018\t0.675500000000\n" +
                        "0.332301996648\t0.332300000000\n" +
                        "0.000001752813\t0.000000000000\n" +
                        "0.000076281818\t0.000100000000\n" +
                        "0.000000005555\t0.000000000000\n" +
                        "0.000002473130\t0.000000000000\n" +
                        "632.921875000000\t632.921900000000\n" +
                        "0.000000020896\t0.000000000000\n" +
                        "0.007371325744\t0.007400000000\n" +
                        "0.000000014643\t0.000000000000\n" +
                        "512.000000000000\t512.000000000000\n" +
                        "864.000000000000\t864.000000000000\n" +
                        "0.000000157437\t0.000000000000\n" +
                        "-842.000000000000\t-842.000000000000\n" +
                        "0.000032060649\t0.000000000000\n",
                "select d, roundHalfDown(d,4) from abc");
    }

    @Test
    public void testRoundHalfEven() throws Exception {
        assertThat("1.050231933594\t1.050200000000\n" +
                        "566.734375000000\t566.734400000000\n" +
                        "0.000013792171\t0.000000000000\n" +
                        "0.000000567185\t0.000000000000\n" +
                        "-512.000000000000\t-512.000000000000\n" +
                        "0.675451681018\t0.675500000000\n" +
                        "0.332301996648\t0.332300000000\n" +
                        "0.000001752813\t0.000000000000\n" +
                        "0.000076281818\t0.000100000000\n" +
                        "0.000000005555\t0.000000000000\n" +
                        "0.000002473130\t0.000000000000\n" +
                        "632.921875000000\t632.921900000000\n" +
                        "0.000000020896\t0.000000000000\n" +
                        "0.007371325744\t0.007400000000\n" +
                        "0.000000014643\t0.000000000000\n" +
                        "512.000000000000\t512.000000000000\n" +
                        "864.000000000000\t864.000000000000\n" +
                        "0.000000157437\t0.000000000000\n" +
                        "-842.000000000000\t-842.000000000000\n" +
                        "0.000032060649\t0.000000000000\n",
                "select d, roundHalfEven(d, 4) from abc");
    }

    @Test
    public void testRoundHalfUp() throws Exception {
        assertThat("1.050231933594\t1.050230000000\n" +
                        "566.734375000000\t566.734380000000\n" +
                        "0.000013792171\t0.000010000000\n" +
                        "0.000000567185\t0.000000000000\n" +
                        "-512.000000000000\t-512.000000000000\n" +
                        "0.675451681018\t0.675450000000\n" +
                        "0.332301996648\t0.332300000000\n" +
                        "0.000001752813\t0.000000000000\n" +
                        "0.000076281818\t0.000080000000\n" +
                        "0.000000005555\t0.000000000000\n" +
                        "0.000002473130\t0.000000000000\n" +
                        "632.921875000000\t632.921880000000\n" +
                        "0.000000020896\t0.000000000000\n" +
                        "0.007371325744\t0.007370000000\n" +
                        "0.000000014643\t0.000000000000\n" +
                        "512.000000000000\t512.000000000000\n" +
                        "864.000000000000\t864.000000000000\n" +
                        "0.000000157437\t0.000000000000\n" +
                        "-842.000000000000\t-842.000000000000\n" +
                        "0.000032060649\t0.000030000000\n",
                "select d, roundHalfUp(d, 5) from abc");
    }

    @Test
    public void testRoundUp() throws Exception {
        assertThat("1.050231933594\t1.050232000000\n" +
                        "566.734375000000\t566.734376000000\n" +
                        "0.000013792171\t0.000014000000\n" +
                        "0.000000567185\t0.000001000000\n" +
                        "-512.000000000000\t-512.000001000000\n" +
                        "0.675451681018\t0.675452000000\n" +
                        "0.332301996648\t0.332302000000\n" +
                        "0.000001752813\t0.000002000000\n" +
                        "0.000076281818\t0.000077000000\n" +
                        "0.000000005555\t0.000001000000\n" +
                        "0.000002473130\t0.000003000000\n" +
                        "632.921875000000\t632.921876000000\n" +
                        "0.000000020896\t0.000001000000\n" +
                        "0.007371325744\t0.007372000000\n" +
                        "0.000000014643\t0.000001000000\n" +
                        "512.000000000000\t512.000001000000\n" +
                        "864.000000000000\t864.000001000000\n" +
                        "0.000000157437\t0.000001000000\n" +
                        "-842.000000000000\t-842.000001000000\n" +
                        "0.000032060649\t0.000033000000\n",
                "select d, roundUp(d, 6) from abc");
    }

    @Test
    public void testRoundUpInvalidScale() throws Exception {
        assertThat("1.050231933594\tNaN\n" +
                        "566.734375000000\tNaN\n" +
                        "0.000013792171\tNaN\n" +
                        "0.000000567185\tNaN\n" +
                        "-512.000000000000\tNaN\n" +
                        "0.675451681018\tNaN\n" +
                        "0.332301996648\tNaN\n" +
                        "0.000001752813\tNaN\n" +
                        "0.000076281818\tNaN\n" +
                        "0.000000005555\tNaN\n" +
                        "0.000002473130\tNaN\n" +
                        "632.921875000000\tNaN\n" +
                        "0.000000020896\tNaN\n" +
                        "0.007371325744\tNaN\n" +
                        "0.000000014643\tNaN\n" +
                        "512.000000000000\tNaN\n" +
                        "864.000000000000\tNaN\n" +
                        "0.000000157437\tNaN\n" +
                        "-842.000000000000\tNaN\n" +
                        "0.000032060649\tNaN\n",
                "select d, roundUp(d, 15) from abc");
    }
}
