/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quickfix.SessionID;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.DoubleNumberTextField;
import quickfix.examples.banzai.IntegerNumberTextField;
import quickfix.examples.banzai.LogonEvent;
import quickfix.examples.banzai.Order;
import quickfix.examples.banzai.OrderSide;
import quickfix.examples.banzai.OrderTIF;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.OrderType;

public class OrderEntryPanel
extends JPanel
implements Observer {
    private boolean symbolEntered = false;
    private boolean quantityEntered = false;
    private boolean limitEntered = false;
    private boolean stopEntered = false;
    private boolean sessionEntered = false;
    private final JTextField symbolTextField = new JTextField();
    private final IntegerNumberTextField quantityTextField = new IntegerNumberTextField();
    private final JComboBox sideComboBox = new JComboBox<Object>(OrderSide.toArray());
    private final JComboBox typeComboBox = new JComboBox<Object>(OrderType.toArray());
    private final JComboBox tifComboBox = new JComboBox<Object>(OrderTIF.toArray());
    private final DoubleNumberTextField limitPriceTextField = new DoubleNumberTextField();
    private final DoubleNumberTextField stopPriceTextField = new DoubleNumberTextField();
    private final JComboBox sessionComboBox = new JComboBox();
    private final JLabel limitPriceLabel = new JLabel("Limit");
    private final JLabel stopPriceLabel = new JLabel("Stop");
    private final JLabel messageLabel = new JLabel(" ");
    private final JButton submitButton = new JButton("Submit");
    private OrderTableModel orderTableModel = null;
    private transient BanzaiApplication application = null;
    private final GridBagConstraints constraints = new GridBagConstraints();

    public OrderEntryPanel(OrderTableModel orderTableModel, BanzaiApplication application) {
        this.setName("OrderEntryPanel");
        this.orderTableModel = orderTableModel;
        this.application = application;
        application.addLogonObserver(this);
        SubmitActivator activator = new SubmitActivator();
        this.symbolTextField.addKeyListener(activator);
        this.quantityTextField.addKeyListener(activator);
        this.limitPriceTextField.addKeyListener(activator);
        this.stopPriceTextField.addKeyListener(activator);
        this.sessionComboBox.addItemListener(activator);
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.setLayout(new GridBagLayout());
        this.createComponents();
    }

    public void addActionListener(ActionListener listener) {
        this.submitButton.addActionListener(listener);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
        if (message == null || message.equals("")) {
            this.messageLabel.setText(" ");
        }
    }

    public void clearMessage() {
        this.setMessage(null);
    }

    private void createComponents() {
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        int x = 0;
        int y = 0;
        this.add(new JLabel("Symbol"), x, y);
        this.add(new JLabel("Quantity"), ++x, y);
        this.add(new JLabel("Side"), ++x, y);
        this.add(new JLabel("Type"), ++x, y);
        this.constraints.ipadx = 30;
        this.add(this.limitPriceLabel, ++x, y);
        this.add(this.stopPriceLabel, ++x, y);
        this.constraints.ipadx = 0;
        this.add(new JLabel("TIF"), ++x, y);
        this.constraints.ipadx = 30;
        this.symbolTextField.setName("SymbolTextField");
        x = 0;
        this.add(this.symbolTextField, 0, ++y);
        this.constraints.ipadx = 0;
        this.quantityTextField.setName("QuantityTextField");
        this.add(this.quantityTextField, ++x, y);
        this.sideComboBox.setName("SideComboBox");
        this.add(this.sideComboBox, ++x, y);
        this.typeComboBox.setName("TypeComboBox");
        this.add(this.typeComboBox, ++x, y);
        this.limitPriceTextField.setName("LimitPriceTextField");
        this.add(this.limitPriceTextField, ++x, y);
        this.stopPriceTextField.setName("StopPriceTextField");
        this.add(this.stopPriceTextField, ++x, y);
        this.tifComboBox.setName("TifComboBox");
        this.add(this.tifComboBox, ++x, y);
        this.constraints.insets = new Insets(3, 0, 0, 0);
        this.constraints.gridwidth = -1;
        this.sessionComboBox.setName("SessionComboBox");
        this.add(this.sessionComboBox, 0, ++y);
        this.constraints.gridwidth = 0;
        this.submitButton.setName("SubmitButton");
        this.add(this.submitButton, x, y);
        this.constraints.gridwidth = 0;
        this.add(this.messageLabel, 0, ++y);
        this.typeComboBox.addItemListener(new PriceListener());
        this.typeComboBox.setSelectedItem(OrderType.STOP);
        this.typeComboBox.setSelectedItem(OrderType.MARKET);
        Font font = new Font(this.messageLabel.getFont().getFontName(), 1, 12);
        this.messageLabel.setFont(font);
        this.messageLabel.setForeground(Color.red);
        this.messageLabel.setHorizontalAlignment(0);
        this.submitButton.setEnabled(false);
        this.submitButton.addActionListener(new SubmitListener());
        this.activateSubmit();
    }

    private JComponent add(JComponent component, int x, int y) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.add((Component)component, this.constraints);
        return component;
    }

    private void activateSubmit() {
        boolean activate;
        OrderType type = (OrderType)this.typeComboBox.getSelectedItem();
        boolean bl = activate = this.symbolEntered && this.quantityEntered && this.sessionEntered;
        if (type == OrderType.MARKET) {
            this.submitButton.setEnabled(activate);
        } else if (type == OrderType.LIMIT) {
            this.submitButton.setEnabled(activate && this.limitEntered);
        } else if (type == OrderType.STOP) {
            this.submitButton.setEnabled(activate && this.stopEntered);
        } else if (type == OrderType.STOP_LIMIT) {
            this.submitButton.setEnabled(activate && this.limitEntered && this.stopEntered);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        LogonEvent logonEvent = (LogonEvent)arg;
        if (logonEvent.isLoggedOn()) {
            this.sessionComboBox.addItem(logonEvent.getSessionID());
        } else {
            this.sessionComboBox.removeItem(logonEvent.getSessionID());
        }
    }

    private class SubmitActivator
    implements KeyListener,
    ItemListener {
        private SubmitActivator() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Object obj = e.getSource();
            if (obj == OrderEntryPanel.this.symbolTextField) {
                OrderEntryPanel.this.symbolEntered = this.testField(obj);
            } else if (obj == OrderEntryPanel.this.quantityTextField) {
                OrderEntryPanel.this.quantityEntered = this.testField(obj);
            } else if (obj == OrderEntryPanel.this.limitPriceTextField) {
                OrderEntryPanel.this.limitEntered = this.testField(obj);
            } else if (obj == OrderEntryPanel.this.stopPriceTextField) {
                OrderEntryPanel.this.stopEntered = this.testField(obj);
            }
            OrderEntryPanel.this.activateSubmit();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            OrderEntryPanel.this.sessionEntered = OrderEntryPanel.this.sessionComboBox.getSelectedItem() != null;
            OrderEntryPanel.this.activateSubmit();
        }

        private boolean testField(Object o) {
            String value = ((JTextField)o).getText();
            return (value = value.trim()).length() > 0;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    private class SubmitListener
    implements ActionListener {
        private SubmitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Order order = new Order();
            order.setSide((OrderSide)OrderEntryPanel.this.sideComboBox.getSelectedItem());
            order.setType((OrderType)OrderEntryPanel.this.typeComboBox.getSelectedItem());
            order.setTIF((OrderTIF)OrderEntryPanel.this.tifComboBox.getSelectedItem());
            order.setSymbol(OrderEntryPanel.this.symbolTextField.getText());
            order.setQuantity(Integer.parseInt(OrderEntryPanel.this.quantityTextField.getText()));
            order.setOpen(order.getQuantity());
            OrderType type = order.getType();
            if (type == OrderType.LIMIT || type == OrderType.STOP_LIMIT) {
                order.setLimit(OrderEntryPanel.this.limitPriceTextField.getText());
            }
            if (type == OrderType.STOP || type == OrderType.STOP_LIMIT) {
                order.setStop(OrderEntryPanel.this.stopPriceTextField.getText());
            }
            order.setSessionID((SessionID)OrderEntryPanel.this.sessionComboBox.getSelectedItem());
            OrderEntryPanel.this.orderTableModel.addOrder(order);
            OrderEntryPanel.this.application.send(order);
        }
    }

    private class PriceListener
    implements ItemListener {
        private PriceListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            OrderType item = (OrderType)OrderEntryPanel.this.typeComboBox.getSelectedItem();
            if (item == OrderType.MARKET) {
                this.enableLimitPrice(false);
                this.enableStopPrice(false);
            } else if (item == OrderType.STOP) {
                this.enableLimitPrice(false);
                this.enableStopPrice(true);
            } else if (item == OrderType.LIMIT) {
                this.enableLimitPrice(true);
                this.enableStopPrice(false);
            } else {
                this.enableLimitPrice(true);
                this.enableStopPrice(true);
            }
            OrderEntryPanel.this.activateSubmit();
        }

        private void enableLimitPrice(boolean enabled) {
            Color labelColor = enabled ? Color.black : Color.gray;
            Color bgColor = enabled ? Color.white : Color.gray;
            OrderEntryPanel.this.limitPriceTextField.setEnabled(enabled);
            OrderEntryPanel.this.limitPriceTextField.setBackground(bgColor);
            OrderEntryPanel.this.limitPriceLabel.setForeground(labelColor);
        }

        private void enableStopPrice(boolean enabled) {
            Color labelColor = enabled ? Color.black : Color.gray;
            Color bgColor = enabled ? Color.white : Color.gray;
            OrderEntryPanel.this.stopPriceTextField.setEnabled(enabled);
            OrderEntryPanel.this.stopPriceTextField.setBackground(bgColor);
            OrderEntryPanel.this.stopPriceLabel.setForeground(labelColor);
        }
    }
}

