/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import quickfix.examples.ordermatch.Order;

public class Market {
    private final List<Order> bidOrders = new ArrayList<Order>();
    private final List<Order> askOrders = new ArrayList<Order>();

    public boolean match(String symbol, List<Order> orders) {
        while (true) {
            if (this.bidOrders.size() == 0 || this.askOrders.size() == 0) {
                return orders.size() != 0;
            }
            Order bidOrder = this.bidOrders.get(0);
            Order askOrder = this.askOrders.get(0);
            if (bidOrder.getType() != '1' && askOrder.getType() != '1' && !(bidOrder.getPrice() >= askOrder.getPrice())) break;
            this.match(bidOrder, askOrder);
            if (!orders.contains(bidOrder)) {
                orders.add(0, bidOrder);
            }
            if (!orders.contains(askOrder)) {
                orders.add(0, askOrder);
            }
            if (bidOrder.isClosed()) {
                this.bidOrders.remove(bidOrder);
            }
            if (!askOrder.isClosed()) continue;
            this.askOrders.remove(askOrder);
        }
        return orders.size() != 0;
    }

    private void match(Order bid, Order ask) {
        double price = ask.getType() == '2' ? ask.getPrice() : bid.getPrice();
        long quantity = bid.getOpenQuantity() >= ask.getOpenQuantity() ? ask.getOpenQuantity() : bid.getOpenQuantity();
        bid.execute(price, quantity);
        ask.execute(price, quantity);
    }

    public boolean insert(Order order) {
        return order.getSide() == '1' ? this.insert(order, true, this.bidOrders) : this.insert(order, false, this.askOrders);
    }

    private boolean insert(Order order, boolean descending, List<Order> orders) {
        if (orders.size() == 0) {
            orders.add(order);
        } else if (order.getType() == '1') {
            orders.add(0, order);
        } else {
            for (int i = 0; i < orders.size(); ++i) {
                Order o = orders.get(i);
                if (!(descending ? order.getPrice() > o.getPrice() : order.getPrice() < o.getPrice()) || order.getEntryTime() >= o.getEntryTime()) continue;
                orders.add(i, order);
            }
            orders.add(order);
        }
        return true;
    }

    public void erase(Order order) {
        if (order.getSide() == '1') {
            this.bidOrders.remove(this.find(this.bidOrders, order.getClientOrderId()));
        } else {
            this.askOrders.remove(this.find(this.askOrders, order.getClientOrderId()));
        }
    }

    public Order find(String symbol, char side, String id) {
        return this.find(side == '1' ? this.bidOrders : this.askOrders, id);
    }

    private Order find(List<Order> orders, String clientOrderId) {
        for (Order order : orders) {
            if (!order.getClientOrderId().equals(clientOrderId)) continue;
            return order;
        }
        return null;
    }

    public void display() {
        this.displaySide(this.bidOrders, "BIDS");
        this.displaySide(this.askOrders, "ASKS");
    }

    private void displaySide(List<Order> orders, String title) {
        DecimalFormat priceFormat = new DecimalFormat("#.00");
        DecimalFormat qtyFormat = new DecimalFormat("######");
        System.out.println(title + ":\n----");
        for (Order order : orders) {
            System.out.println("  $" + priceFormat.format(order.getPrice()) + " " + qtyFormat.format(order.getOpenQuantity()) + " " + order.getOwner() + " " + new Date(order.getEntryTime()));
        }
    }
}

