/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.testng;

import java.lang.reflect.Method;
import java.util.Collection;
import org.quickperf.SystemProperties;
import org.quickperf.TestExecutionContext;
import org.quickperf.config.library.QuickPerfConfigs;
import org.quickperf.config.library.QuickPerfConfigsLoader;
import org.quickperf.config.library.SetOfAnnotationConfigs;
import org.quickperf.issue.JvmOrTestIssue;
import org.quickperf.issue.PerfIssuesEvaluator;
import org.quickperf.issue.TestIssue;
import org.quickperf.jvm.JVM;
import org.quickperf.perfrecording.PerformanceRecording;
import org.quickperf.reporter.QuickPerfReporter;
import org.quickperf.testlauncher.NewJvmTestLauncher;
import org.quickperf.testng.QuickPerfTestNGCore;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class QuickPerfTestNGListener
implements IHookable {
    private final QuickPerfConfigs quickPerfConfigs = QuickPerfConfigsLoader.INSTANCE.loadQuickPerfConfigs();
    private final PerfIssuesEvaluator perfIssuesEvaluator = PerfIssuesEvaluator.INSTANCE;
    private final PerformanceRecording performanceRecording = PerformanceRecording.INSTANCE;
    private final QuickPerfReporter quickPerfReporter = QuickPerfReporter.INSTANCE;

    public void run(IHookCallBack hookCallBack, ITestResult testResult) {
        TestExecutionContext testExecutionContext = this.buildTestExecutionContext(testResult);
        if (testExecutionContext.isQuickPerfDisabled()) {
            hookCallBack.runTestMethod(testResult);
            return;
        }
        if (((Boolean)SystemProperties.TEST_CODE_EXECUTING_IN_NEW_JVM.evaluate()).booleanValue()) {
            this.executeTestMethodInNewJvmAndRecordPerformance(testResult, testExecutionContext);
            return;
        }
        JvmOrTestIssue jvmOrTestIssue = this.executeTestMethodAndRecordPerformance(hookCallBack, testResult, testExecutionContext);
        SetOfAnnotationConfigs testAnnotationConfigs = this.quickPerfConfigs.getTestAnnotationConfigs();
        Collection groupOfPerfIssuesToFormat = this.perfIssuesEvaluator.evaluatePerfIssuesIfNoJvmIssue(testAnnotationConfigs, testExecutionContext, jvmOrTestIssue);
        testExecutionContext.cleanResources();
        try {
            this.quickPerfReporter.report(jvmOrTestIssue, groupOfPerfIssuesToFormat, testExecutionContext);
        }
        catch (Throwable throwable) {
            testResult.setThrowable(throwable);
            testResult.setStatus(2);
        }
    }

    private TestExecutionContext buildTestExecutionContext(ITestResult testResult) {
        Method testMethod = this.extractTestMethod(testResult);
        int testNGAllocationOffset = this.findTestNGAllocationOffset();
        return TestExecutionContext.buildFrom((QuickPerfConfigs)this.quickPerfConfigs, (Method)testMethod, (int)testNGAllocationOffset);
    }

    private int findTestNGAllocationOffset() {
        JVM.Version jvmVersion = JVM.INSTANCE.version;
        if (jvmVersion.isGreaterThanOrEqualTo12()) {
            return 72;
        }
        return 40;
    }

    private Method extractTestMethod(ITestResult testResult) {
        ITestNGMethod testNGMethod = testResult.getMethod();
        return testNGMethod.getConstructorOrMethod().getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestMethodInNewJvmAndRecordPerformance(ITestResult testResult, TestExecutionContext testExecutionContext) {
        Object[] args = new Object[]{};
        Method method = this.extractTestMethod(testResult);
        this.performanceRecording.start(testExecutionContext);
        try {
            Object target = testResult.getInstance();
            method.invoke(target, args);
        }
        catch (Throwable throwable) {
            testResult.setThrowable(throwable);
            testResult.setStatus(2);
        }
        finally {
            this.performanceRecording.stop(testExecutionContext);
        }
    }

    private JvmOrTestIssue executeTestMethodAndRecordPerformance(IHookCallBack hookCallBack, ITestResult testResult, TestExecutionContext testExecutionContext) {
        if (testExecutionContext.testExecutionUsesTwoJVMs()) {
            Method testMethod = this.extractTestMethod(testResult);
            return this.executeTestMethodInNewJwm(testMethod, testExecutionContext);
        }
        TestIssue testIssue = this.executeTestMethodAndRecordPerformanceInSameJvm(hookCallBack, testResult, testExecutionContext);
        return JvmOrTestIssue.buildFrom((TestIssue)testIssue);
    }

    private JvmOrTestIssue executeTestMethodInNewJwm(Method testMethod, TestExecutionContext testExecutionContext) {
        NewJvmTestLauncher newJvmTestLauncher = NewJvmTestLauncher.INSTANCE;
        return newJvmTestLauncher.executeTestMethodInNewJwm(testMethod, testExecutionContext, QuickPerfTestNGCore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestIssue executeTestMethodAndRecordPerformanceInSameJvm(IHookCallBack hookCallBack, ITestResult testResult, TestExecutionContext testExecutionContext) {
        this.performanceRecording.start(testExecutionContext);
        try {
            hookCallBack.runTestMethod(testResult);
            TestIssue testIssue = TestIssue.NONE;
            return testIssue;
        }
        catch (Throwable throwable) {
            TestIssue testIssue = TestIssue.buildFrom((Throwable)throwable);
            return testIssue;
        }
        finally {
            this.performanceRecording.stop(testExecutionContext);
        }
    }
}

