/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.testng;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.quickperf.issue.TestIssue;
import org.quickperf.testlauncher.TestRunnerFromMain;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

class TestNGTestRunner
implements TestRunnerFromMain.FrameworkTestRunner {
    TestNGTestRunner() {
    }

    public TestIssue executeTestMethod(Class<?> testClass, String methodName) {
        TestNG testNG = TestNGTestRunner.createTestNGInstance(testClass, methodName);
        TestListenerAdapter testListenerAdapter = new TestListenerAdapter();
        testNG.addListener((ITestNGListener)testListenerAdapter);
        testNG.run();
        List failedTests = testListenerAdapter.getFailedTests();
        List<Throwable> failuresAsThrowables = this.convertToThrowables(failedTests);
        return TestIssue.buildInNewJvmFrom(failuresAsThrowables);
    }

    private static TestNG createTestNGInstance(Class<?> testClass, String methodName) {
        TestNG result = new TestNG();
        result.setUseDefaultListeners(false);
        result.setVerbose(0);
        Class[] testClasses = new Class[]{testClass};
        result.setTestClasses(testClasses);
        TestMethodInterceptor methodInterceptor = new TestMethodInterceptor(methodName);
        result.setMethodInterceptor((IMethodInterceptor)methodInterceptor);
        return result;
    }

    private List<Throwable> convertToThrowables(List<ITestResult> failedTests) {
        return failedTests.stream().map(failedTest -> {
            Throwable throwable = failedTest.getThrowable();
            return throwable.getCause();
        }).collect(Collectors.toList());
    }

    static class TestMethodInterceptor
    implements IMethodInterceptor {
        private final String testMethodNameToRun;

        TestMethodInterceptor(String testMethodNameToRun) {
            this.testMethodNameToRun = testMethodNameToRun;
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            Predicate<IMethodInstance> selectTestMethod = method -> {
                ITestNGMethod testNGMethod = method.getMethod();
                String currentMethodName = testNGMethod.getMethodName();
                return currentMethodName.equals(this.testMethodNameToRun);
            };
            IMethodInstance testMethod = methods.stream().filter(selectTestMethod).findFirst().get();
            return Collections.singletonList(testMethod);
        }
    }
}

