/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dashboard.actions.DashboardAction;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractCreateAndEditPageAction;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugins.templates.actions.AbstractEditPageTemplateAction;
import com.atlassian.confluence.plugins.templates.actions.AbstractPageTemplateAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.randombits.support.confluence.ContextAssistant;

public class DefaultContextAssistant
implements ContextAssistant {
    private static final String DECORATOR_PARAM = "decorator";
    private static final String PRINTABLE_DECORATOR = "printable";
    private final PageTemplateManager pageTemplateManager;
    private final PageManager pageManager;

    public DefaultContextAssistant(PageTemplateManager pageTemplateManager, PageManager pageManager) {
        this.pageTemplateManager = pageTemplateManager;
        this.pageManager = pageManager;
    }

    @Override
    public PageTemplate getPageTemplate(String templateName, Space space) {
        PageTemplate pt = null;
        if (space != null) {
            pt = this.pageTemplateManager.getPageTemplate(templateName, space);
        }
        if (pt == null) {
            pt = this.pageTemplateManager.getPageTemplate(templateName, null);
        }
        if (pt == null) {
            List pageTemplates = this.pageTemplateManager.getGlobalPageTemplates();
            for (PageTemplate lpt : pageTemplates) {
                if (!lpt.getName().equals(templateName)) continue;
                return lpt;
            }
            return null;
        }
        return pt;
    }

    @Override
    public List<PageTemplate> getPageTemplates(Space space) {
        List templates = this.pageTemplateManager.getGlobalPageTemplates();
        if (space != null) {
            templates.addAll(this.pageTemplateManager.getPageTemplates(space));
        }
        return templates;
    }

    @Override
    public boolean isViewAction(ConversionContext ctx) {
        HttpServletRequest req = ServletActionContext.getRequest();
        if (req == null) {
            return false;
        }
        Action action = DefaultContextAssistant.getCurrentAction();
        ContentEntityObject content = ctx.getEntity();
        return content instanceof AbstractPage && action instanceof ViewPageAction;
    }

    private static Action getCurrentAction() {
        ActionInvocation ai;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null && (ai = ctx.getActionInvocation()) != null) {
            return ai.getAction();
        }
        return null;
    }

    @Override
    public boolean isEditAction(ConversionContext ctx) {
        Action action = DefaultContextAssistant.getCurrentAction();
        ContentEntityObject content = ctx.getEntity();
        if (content instanceof AbstractPage) {
            if (action instanceof AbstractCreateAndEditPageAction) {
                return true;
            }
        } else if (content == null) {
            return this.isCurrentAction(AbstractEditPageTemplateAction.class);
        }
        return false;
    }

    @Override
    public boolean isDashboardAction(ConversionContext ctx) {
        return this.isCurrentAction(DashboardAction.class);
    }

    @Override
    public boolean isTemplateAction(ConversionContext ctx) {
        return this.isCurrentAction(AbstractPageTemplateAction.class);
    }

    @Override
    public boolean isCurrentAction(Class<? extends Action> actionClass) {
        Action action = DefaultContextAssistant.getCurrentAction();
        return action != null && actionClass.isInstance(action);
    }

    @Override
    public boolean isDefaultDisplay(ConversionContext ctx) {
        HttpServletRequest req = ServletActionContext.getRequest();
        return req != null && StringUtils.isBlank((String)req.getParameter(DECORATOR_PARAM)) && "display".equals(ctx.getOutputType());
    }

    @Override
    public boolean isPrintableDisplay(ConversionContext ctx) {
        if ("pdf".equals(ctx.getOutputType()) || "word".equals(ctx.getOutputType())) {
            return true;
        }
        HttpServletRequest req = ServletActionContext.getRequest();
        return req != null && PRINTABLE_DECORATOR.equals(req.getParameter(DECORATOR_PARAM));
    }

    @Override
    public boolean isPDFDisplay(ConversionContext ctx) {
        return "pdf".equals(ctx.getOutputType());
    }

    @Override
    public boolean isWordDisplay(ConversionContext ctx) {
        return "word".equals(ctx.getOutputType());
    }

    @Override
    public boolean isPreviewDisplay(ConversionContext ctx) {
        return "preview".equals(ctx.getOutputType());
    }

    @Override
    public boolean isRecentlyUpdatedFor(ContentEntityObject ceo, Object user) {
        User realUser = (User)user;
        return ceo instanceof Page && this.pageManager.isPageRecentlyUpdatedForUser((Page)ceo, realUser);
    }

    @Override
    public PageTemplate getCurrentPageTemplate(ConversionContext ctx) {
        if (this.isTemplateAction(ctx)) {
            AbstractPageTemplateAction action = (AbstractPageTemplateAction)DefaultContextAssistant.getCurrentAction();
            return action.getPageTemplate();
        }
        return null;
    }
}

