/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.links.DefaultHrefEvaluator;
import com.atlassian.confluence.content.render.xhtml.links.HrefEvaluator;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.util.AbstractCollection;
import java.util.EnumSet;
import org.apache.commons.lang.StringUtils;
import org.randombits.support.confluence.LinkAssistant;
import org.randombits.support.core.env.EnvironmentAssistant;

public final class DefaultLinkAssistant
implements LinkAssistant {
    private static final char SPACE_SEPARATOR = ':';
    private static final char ATTACHMENT_SEPARATOR = '^';
    private static final char ANCHOR_SEPARATOR = '#';
    private static final char ID_PREFIX = '$';
    private final PermissionManager permissionManager;
    private final ContextPathHolder contextPathHolder;
    private final HrefEvaluator hrefEvaluator;
    private final EnvironmentAssistant environmentAssistant;
    private final LinkManager linkManager;
    private final PageManager pageManager;
    private final AttachmentManager attachmentManager;

    public DefaultLinkAssistant(PermissionManager permissionManager, ContextPathHolder contextPathHolder, EnvironmentAssistant environmentAssistant, LinkManager linkManager, PageManager pageManager, AttachmentManager attachmentManager) {
        this.permissionManager = permissionManager;
        this.contextPathHolder = contextPathHolder;
        this.linkManager = linkManager;
        this.environmentAssistant = environmentAssistant;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.hrefEvaluator = new DefaultHrefEvaluator(contextPathHolder);
    }

    private boolean requiresContextPath(String url) {
        return !StringUtils.isEmpty((String)url) && url.startsWith("/");
    }

    @Override
    public String getURLForWikiLink(ConversionContext context, String linkText) {
        ConfluenceEntityObject ceo = this.getEntityForWikiLink(context, linkText);
        if (ceo != null) {
            return this.getURLForEntity(context, ceo);
        }
        if (this.requiresContextPath(linkText)) {
            linkText = this.contextPathHolder.getContextPath() + linkText;
        }
        return linkText;
    }

    @Override
    public String getContextPath() {
        return this.contextPathHolder.getContextPath();
    }

    @Override
    public boolean saveOutgoingLink(ContentEntityObject sourceContent, ConfluenceEntityObject targetContent) {
        OutgoingLink link = this.getOutgoingLink(sourceContent, targetContent);
        if (link != null) {
            this.linkManager.saveLink(link);
            return true;
        }
        return false;
    }

    @Override
    public boolean saveOutgoingLink(ContentEntityObject sourceContent, String spaceKey, String targetPageTitle) {
        if (spaceKey == null) {
            if (sourceContent instanceof SpaceContentEntityObject) {
                spaceKey = ((SpaceContentEntityObject)sourceContent).getSpaceKey();
            } else {
                return false;
            }
        }
        OutgoingLink link = new OutgoingLink(sourceContent, spaceKey, targetPageTitle);
        this.linkManager.saveLink(link);
        return true;
    }

    private OutgoingLink getOutgoingLink(ContentEntityObject sourceContent, ConfluenceEntityObject targetContent) {
        if (targetContent instanceof Attachment) {
            targetContent = ((Attachment)targetContent).getContent();
        }
        if (targetContent instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject sceo = (SpaceContentEntityObject)targetContent;
            String spaceKey = sceo.getSpaceKey();
            String contentTitle = sceo.getTitle();
            return new OutgoingLink(sourceContent, spaceKey, contentTitle);
        }
        return null;
    }

    @Override
    public boolean saveOutgoingLink(ContentEntityObject sourceContent, String url) {
        int split = url.indexOf(58);
        if (split >= 0) {
            return this.saveOutgoingLink(sourceContent, url.substring(0, split), url.substring(split + 1));
        }
        return this.saveOutgoingLink(sourceContent, null, url);
    }

    @Override
    public String getURLForEntity(ConversionContext context, ConfluenceEntityObject ceo) {
        return this.getURLForEntity(context, ceo, null);
    }

    @Override
    public String getURLForEntity(ConversionContext context, ConfluenceEntityObject ceo, String anchor) {
        if (ceo != null) {
            return this.hrefEvaluator.createHref(context, (Object)ceo, anchor);
        }
        return anchor;
    }

    @Override
    public ConfluenceEntityObject getEntityForWikiLink(ConversionContext context, String linkText) {
        ConfluenceEntityObject content = this.findEntityForWikiLink(context.getSpaceKey(), linkText, EnumSet.noneOf(LinkPart.class));
        if (content != null) {
            User user = (User)this.environmentAssistant.getValue(User.class);
            return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)content) ? content : null;
        }
        return null;
    }

    private ConfluenceEntityObject findEntityForWikiLink(String spaceKey, String linkText, EnumSet<LinkPart> processed) {
        Page content = null;
        if (AbstractPage.isValidPageTitle((String)linkText)) {
            content = this.pageManager.getPage(spaceKey, linkText);
        }
        if (content == null && linkText.startsWith(String.valueOf('$'))) {
            try {
                long id = Long.parseLong(linkText.substring(1));
                content = this.pageManager.getById(id);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (content == null) {
            int lastAnchor;
            if (!processed.contains((Object)LinkPart.ANCHOR) && (lastAnchor = linkText.lastIndexOf(35)) >= 0) {
                content = this.findEntityForWikiLink(spaceKey, linkText.substring(0, lastAnchor), this.addPart(processed, LinkPart.ANCHOR));
            }
            if (content == null) {
                int firstSpace;
                int lastAttachment;
                if (!processed.contains((Object)LinkPart.ATTACHMENT_NAME) && (lastAttachment = linkText.lastIndexOf(94)) >= 0) {
                    String pageTitle = linkText.substring(0, lastAttachment);
                    String attachmentName = linkText.substring(lastAttachment + 1);
                    ConfluenceEntityObject page = this.findEntityForWikiLink(spaceKey, pageTitle, this.addPart(processed, LinkPart.ATTACHMENT_NAME));
                    if (page instanceof ContentEntityObject) {
                        content = this.attachmentManager.getAttachment((ContentEntityObject)page, attachmentName);
                    }
                }
                if (content == null && !processed.contains((Object)LinkPart.SPACE_KEY) && (firstSpace = linkText.indexOf(58)) >= 0) {
                    String space = linkText.substring(0, firstSpace);
                    String pageTitle = linkText.substring(firstSpace + 1);
                    content = this.findEntityForWikiLink(space, pageTitle, this.addPart(processed, LinkPart.SPACE_KEY));
                }
            }
        }
        return content;
    }

    private EnumSet<LinkPart> addPart(EnumSet<LinkPart> processedParts, LinkPart anchor) {
        Object clone = processedParts.clone();
        ((AbstractCollection)clone).add(anchor);
        return clone;
    }

    @Override
    public String getWikiLinkForEntity(ConversionContext context, ConfluenceEntityObject entity) {
        PageContext ctx = context.getPageContext();
        if (ctx == null) {
            return null;
        }
        StringBuilder buff = entity instanceof Attachment ? this.getAttachmentWikiLink((Attachment)entity, ctx) : (entity instanceof ContentEntityObject ? this.getContentEntityWikiLink((ContentEntityObject)entity, ctx) : new StringBuilder("$").append(entity.getId()));
        return buff.toString();
    }

    private StringBuilder getAttachmentWikiLink(Attachment attachment, PageContext ctx) {
        StringBuilder buff;
        if (!(attachment.getContent() instanceof AbstractPage)) {
            buff = new StringBuilder().append(GeneralUtil.getGlobalSettings().getBaseUrl()).append(attachment.getUrlPath());
        } else {
            buff = ctx == null || !ctx.getEntity().equals((Object)attachment.getContent()) ? this.getContentEntityWikiLink(attachment.getContent(), ctx) : new StringBuilder();
            buff.append("^").append(attachment.getFileName());
        }
        return buff;
    }

    private StringBuilder getContentEntityWikiLink(ContentEntityObject content, PageContext ctx) {
        StringBuilder buff = new StringBuilder();
        if (content instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject spaceContent = (SpaceContentEntityObject)content;
            if (!StringUtils.equals((String)spaceContent.getSpaceKey(), (String)ctx.getSpaceKey())) {
                buff.append(spaceContent.getSpaceKey()).append(":");
            }
            if (content instanceof Page) {
                Page page = (Page)content;
                buff.append(page.getTitle());
            } else if (content instanceof BlogPost) {
                BlogPost blogPost = (BlogPost)content;
                buff.append(blogPost.getDatePath()).append("/").append(blogPost.getTitle());
            } else {
                buff.append("$").append(content.getIdAsString());
            }
        } else if (content instanceof PersonalInformation) {
            buff.append("~").append(((PersonalInformation)content).getUsername());
        } else {
            buff.append("$").append(content.getIdAsString());
        }
        return buff;
    }

    private static enum LinkPart {
        ANCHOR,
        SPACE_KEY,
        ATTACHMENT_NAME,
        PAGE_TITLE;

    }
}

