/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.randombits.storage.EmptyStorage;
import org.randombits.storage.IndexedStorage;
import org.randombits.storage.MapStorage;
import org.randombits.storage.Storage;
import org.randombits.storage.confluence.ConversionContextStorage;
import org.randombits.storage.confluence.MacroParameterStorage;
import org.randombits.support.confluence.DefaultMacroAssistant;
import org.randombits.support.confluence.MacroAssistant;
import org.randombits.support.confluence.MacroParameterSource;
import org.randombits.support.confluence.PageInfo;
import org.randombits.support.core.env.EnvironmentAssistant;
import org.randombits.support.core.param.ParameterAssistant;
import org.randombits.support.core.param.ParameterSource;
import org.randombits.support.core.param.Parameters;

public class MacroInfo
extends PageInfo {
    public static final String MACRO_BODY = "@body";
    private static final ThreadLocal<ConversionContext> CONVERSION_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private final MacroAssistant macroAssistant;
    private final ParameterAssistant parameterAssistant;
    private final String body;
    private Map<String, String> macroParamsMap;
    private IndexedStorage macroParams;
    private XhtmlContent xhtmlContent;
    protected ConversionContext conversionContext;
    private Storage contextParams;
    private MacroExecutionContext macroExecutionContext;

    public static ConversionContext getCurrentConversionContext() {
        return CONVERSION_CONTEXT_THREAD_LOCAL.get();
    }

    @Deprecated
    public MacroInfo(Map<String, String> params, String body, ConversionContext conversionContext, EnvironmentAssistant environmentAssistant, XhtmlContent xhtmlContent) throws MacroExecutionException {
        this(MacroInfo.createParameterStorage(params), body, conversionContext, environmentAssistant, xhtmlContent);
    }

    @Deprecated
    public MacroInfo(IndexedStorage params, String body, ConversionContext conversionContext, EnvironmentAssistant environmentAssistant, XhtmlContent xhtmlContent) {
        this(params, body, conversionContext, (MacroAssistant)new DefaultMacroAssistant(environmentAssistant, xhtmlContent, null));
    }

    @Deprecated
    public MacroInfo(IndexedStorage macroParams, String body, MacroInfo info, EnvironmentAssistant environmentAssistant, XhtmlContent xhtmlContent) {
        this(macroParams, body, info.getConversionContext(), environmentAssistant, xhtmlContent);
    }

    public MacroInfo(MacroInfo info) {
        this(info.macroParams, info.body, info.conversionContext, info.getMacroAssistant());
    }

    public MacroInfo(IndexedStorage params, String body, ConversionContext conversionContext, MacroAssistant macroAssistant) {
        this(MacroInfo.getMapFromStorage((Storage)params), body, conversionContext, macroAssistant);
        this.macroParams = params;
    }

    public MacroInfo(Map<String, String> params, String body, ConversionContext conversionContext, MacroAssistant macroAssistant) {
        super(macroAssistant.getEnvironmentAssistant(), conversionContext.getEntity());
        this.macroAssistant = macroAssistant;
        this.macroParamsMap = params;
        this.body = body;
        this.xhtmlContent = macroAssistant.getXhtmlContent();
        this.parameterAssistant = macroAssistant.getParameterAssistant();
        this.setConversionContext(conversionContext);
        this.macroParamsMap.put(MACRO_BODY, body);
    }

    public MacroInfo(IndexedStorage macroParams, String body, MacroInfo info, MacroAssistant macroAssistant) {
        this(macroParams, body, info.getConversionContext(), macroAssistant);
    }

    public static IndexedStorage createParameterStorage(Map<String, String> params) {
        return new MacroParameterStorage(params);
    }

    @Deprecated
    public List<MacroDefinition> getPageMacros() throws XhtmlException {
        if (this.xhtmlContent != null) {
            final ArrayList<MacroDefinition> macros = new ArrayList<MacroDefinition>();
            ContentEntityObject pageCEO = this.conversionContext.getEntity();
            String pageContent = pageCEO.getBodyAsString();
            this.xhtmlContent.handleMacroDefinitions(pageContent, this.conversionContext, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    macros.add(macroDefinition);
                }
            });
            return macros;
        }
        return Collections.EMPTY_LIST;
    }

    public MacroExecutionContext asMacroExecutionContext() {
        if (this.macroExecutionContext == null) {
            Map params = MacroInfo.getMapFromStorage((Storage)this.macroParams);
            this.macroExecutionContext = new MacroExecutionContext(params, this.getMacroBody(), this.getConversionContext().getPageContext());
        }
        return this.macroExecutionContext;
    }

    private static Map getMapFromStorage(Storage storage) {
        if (storage instanceof MapStorage) {
            return ((MapStorage)storage).getBaseMap();
        }
        if (storage instanceof MacroParameterStorage) {
            return ((MacroParameterStorage)storage).getOriginalParams();
        }
        return new HashMap();
    }

    public String getMacroBody() {
        return this.body;
    }

    public IndexedStorage getMacroParams() {
        if (this.macroParams == null) {
            this.macroParams = MacroInfo.createParameterStorage(this.macroParamsMap);
        }
        return this.macroParams;
    }

    public <T extends Parameters> T getMacroParams(Class<T> paramsClass) {
        return (T)this.parameterAssistant.createParameters(paramsClass, this.createParameterSource());
    }

    protected ParameterSource createParameterSource() {
        return new MacroParameterSource(this);
    }

    public Map<String, String> getMacroParamsMap() {
        return this.macroParamsMap;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public Storage getConversionContextParams() {
        if (this.contextParams == null) {
            this.contextParams = this.conversionContext == null ? new EmptyStorage() : new ConversionContextStorage(this.conversionContext);
        }
        return this.contextParams;
    }

    private void setConversionContext(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
        CONVERSION_CONTEXT_THREAD_LOCAL.set(conversionContext);
    }

    public XhtmlContent getXhtmlContent() {
        return this.xhtmlContent;
    }

    @Override
    public void close() {
        super.close();
        if (CONVERSION_CONTEXT_THREAD_LOCAL.get() == this.conversionContext) {
            CONVERSION_CONTEXT_THREAD_LOCAL.remove();
        }
        this.conversionContext = null;
    }

    public ParameterAssistant getParameterAssistant() {
        return this.parameterAssistant;
    }

    public MacroAssistant getMacroAssistant() {
        return this.macroAssistant;
    }
}

