/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence.render;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import org.randombits.support.confluence.render.RenderType;
import org.randombits.support.confluence.render.Renderable;

public class BodyContentRenderable
implements Renderable {
    private final BodyContent bodyContent;
    private final RenderType renderType;

    public BodyContentRenderable(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
        BodyType bodyType = bodyContent.getBodyType();
        this.renderType = BodyType.XHTML.equals((Object)bodyType) ? RenderType.RICHTEXT : (BodyType.WIKI.equals((Object)bodyType) ? RenderType.WIKI : RenderType.PLAIN);
    }

    @Override
    public String getText() {
        return this.bodyContent.getBody();
    }

    @Override
    public RenderType getType() {
        return this.renderType;
    }

    @Override
    public ConversionContext getConversionContext() {
        PageContext ctx = null;
        if (this.bodyContent != null && this.bodyContent.getContent() != null) {
            ctx = this.bodyContent.getContent().toPageContext();
        }
        if (ctx == null) {
            ctx = new PageContext();
        }
        return new DefaultConversionContext((RenderContext)ctx);
    }
}

