/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.date;

import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;
import org.joda.time.MutableDateTime;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadablePeriod;
import org.randombits.utils.date.DatePeriodException;

public final class DateUtils {
    private static final Pattern PERIOD_PATTERN = Pattern.compile("\\s*([\\-\\+]?)((?:\\s*[0-9]+\\s*[a-zA-Z]+)+)\\s*");
    private static final Pattern PERIOD_SECTION_PATTERN = Pattern.compile("\\s*([0-9]+)\\s*([a-zA-Z]+)");
    private static final Pattern ROUND_PATTERN = Pattern.compile("\\s*([\\-\\+]?)\\s*([0-9]+)\\s*([a-zA-Z]+)\\s*");

    public static boolean isPeriod(String periodString) {
        return PERIOD_PATTERN.matcher(periodString).matches();
    }

    public static Period getPeriod(String periodString) throws DatePeriodException {
        MutablePeriod period = Period.ZERO.toMutablePeriod();
        Matcher periodMatcher = PERIOD_PATTERN.matcher(periodString);
        if (!periodMatcher.matches()) {
            throw new DatePeriodException("Invalid period: " + periodString);
        }
        Shift shift = Shift.find(periodMatcher.group(1));
        int modifier = Shift.DOWN.equals((Object)shift) ? -1 : 1;
        Matcher matcher = PERIOD_SECTION_PATTERN.matcher(periodMatcher.group(2));
        PeriodType type = null;
        while (matcher.find()) {
            int amount = DateUtils.parseAmount(matcher.group(1));
            type = PeriodType.forKey(matcher.group(2), type);
            if (type == null) {
                throw new DatePeriodException("Invalid period type: " + matcher.group(2));
            }
            period.add(type.getDurationFieldType(), amount * modifier);
        }
        return period.toPeriod();
    }

    public static ReadableDateTime shiftDate(ReadableDateTime dateTime, String periodString) {
        Period period = DateUtils.getPeriod(periodString);
        return dateTime.toDateTime().plus((ReadablePeriod)period);
    }

    public static Date shiftDate(Date date, String period) {
        return DateUtils.shiftDate((ReadableDateTime)new DateTime((Object)date), period).toDateTime().toDate();
    }

    public static ReadableDateTime roundDate(ReadableDateTime dateTime, String periodString) {
        MutableDateTime mDateTime = dateTime.toMutableDateTime();
        Matcher matcher = ROUND_PATTERN.matcher(periodString);
        if (!matcher.matches()) {
            throw new DatePeriodException("Invalid period pattern: " + periodString);
        }
        Shift shift = Shift.find(matcher.group(1));
        int amount = DateUtils.parseAmount(matcher.group(2));
        PeriodType periodType = PeriodType.forKey(matcher.group(3), null);
        if (periodType == null) {
            throw new DatePeriodException("Invalid period: " + matcher.group(3));
        }
        MutableDateTime.Property property = mDateTime.property(periodType.getDateTimeFieldType());
        switch (shift) {
            case NEAREST: {
                property.roundHalfCeiling();
                break;
            }
            case UP: {
                property.roundCeiling();
                break;
            }
            case DOWN: {
                property.roundFloor();
            }
        }
        int baseValue = periodType.getBaseValue();
        int propertyVal = property.get() - baseValue;
        int div = propertyVal / amount;
        int mod = propertyVal % amount;
        if (shift == Shift.NEAREST && mod >= (amount + amount % 2) / 2 || shift == Shift.UP && mod > 0) {
            ++div;
        }
        property.set(div * amount + baseValue);
        return mDateTime;
    }

    private static int parseAmount(String amount) {
        try {
            return Integer.parseInt(amount);
        }
        catch (NumberFormatException e) {
            throw new DatePeriodException("Invalid amount value: " + amount);
        }
    }

    private static enum Shift {
        NEAREST(""),
        UP("+"),
        DOWN("-");

        private final String key;

        private Shift(String key) {
            this.key = key;
        }

        public static Shift find(String key) {
            for (Shift shift : Shift.values()) {
                if (!shift.key.equals(key)) continue;
                return shift;
            }
            return null;
        }
    }

    private static enum PeriodType {
        YEARS(DurationFieldType.years(), DateTimeFieldType.year(), 0),
        MONTHS(DurationFieldType.months(), DateTimeFieldType.monthOfYear(), 1),
        WEEKS(DurationFieldType.weeks(), DateTimeFieldType.weekOfWeekyear(), 1),
        DAYS(DurationFieldType.days(), DateTimeFieldType.dayOfMonth(), 1),
        HOURS(DurationFieldType.hours(), DateTimeFieldType.hourOfDay(), 0),
        MINUTES(DurationFieldType.minutes(), DateTimeFieldType.minuteOfDay(), 0),
        SECONDS(DurationFieldType.seconds(), DateTimeFieldType.secondOfMinute(), 0);

        private final DurationFieldType durationFieldType;
        private final DateTimeFieldType dateTimeFieldType;
        private final int baseValue;

        private PeriodType(DurationFieldType durationFieldType, DateTimeFieldType dateTimeFieldType, int baseValue) {
            this.durationFieldType = durationFieldType;
            this.dateTimeFieldType = dateTimeFieldType;
            this.baseValue = baseValue;
        }

        public DurationFieldType getDurationFieldType() {
            return this.durationFieldType;
        }

        public static PeriodType forKey(String key, PeriodType lastPeriod) {
            ArrayList<PeriodType> matches = new ArrayList<PeriodType>();
            key = key.toUpperCase();
            for (PeriodType type : PeriodType.values()) {
                if (!type.name().startsWith(key)) continue;
                matches.add(type);
            }
            if (matches.size() == 1) {
                return (PeriodType)((Object)matches.get(0));
            }
            if (matches.size() == 0) {
                return null;
            }
            if (lastPeriod != null) {
                for (PeriodType type : matches) {
                    if (type.compareTo(lastPeriod) <= 0) continue;
                    return type;
                }
            }
            return (PeriodType)((Object)matches.get(0));
        }

        public DateTimeFieldType getDateTimeFieldType() {
            return this.dateTimeFieldType;
        }

        public int getBaseValue() {
            return this.baseValue;
        }
    }
}

