/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClassUtils {
    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        Type[] actualTypeArguments;
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ClassUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            assert (parameterizedType != null);
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments2.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments2[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        if (type instanceof Class) {
            actualTypeArguments = type.getTypeParameters();
        } else {
            assert (type != null);
            actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        }
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ClassUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }
}

