/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.text;

import java.nio.CharBuffer;
import java.text.Collator;
import org.randombits.utils.text.TextBuffer;
import org.randombits.utils.text.TextProcessor;

public class LetterProcessor
implements TextProcessor {
    private Collator collator;

    public LetterProcessor() {
        this(null);
    }

    public LetterProcessor(Collator collator) {
        this.collator = collator;
    }

    private boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    @Override
    public boolean canProcess(CharBuffer text) {
        return text.hasRemaining() && this.isLetter(text.get());
    }

    @Override
    public int compare(CharBuffer text1, CharBuffer text2) {
        TextBuffer v1 = this.getLetters(text1);
        TextBuffer v2 = this.getLetters(text2);
        if (this.collator == null) {
            return v1.compareTo(v2);
        }
        return this.collator.compare(v1.toString(), v2.toString());
    }

    private TextBuffer getLetters(CharBuffer text) {
        TextBuffer out = new TextBuffer();
        while (text.hasRemaining() && this.isLetter(text.charAt(0))) {
            out.add(text.get());
        }
        if (out.length() == 0) {
            throw new IllegalArgumentException("Expected letter: " + text);
        }
        return out;
    }
}

