/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.text;

import java.util.BitSet;
import java.util.regex.Pattern;

public final class PatternUtils {
    private static final BitSet RESERVED = new BitSet(65535);

    private PatternUtils() {
    }

    public static Pattern compileSimple(String pattern) {
        String expanded = PatternUtils.expandSimple(pattern);
        return Pattern.compile(expanded);
    }

    private static String expandSimple(String pattern) {
        char[] chars;
        StringBuilder expanded = new StringBuilder();
        for (char aChar : chars = pattern.toCharArray()) {
            if (RESERVED.get(aChar)) {
                if (aChar == '?') {
                    expanded.append(".{1}");
                    continue;
                }
                if (aChar == '*') {
                    expanded.append(".*?");
                    continue;
                }
                expanded.append('\\').append(aChar);
                continue;
            }
            expanded.append(aChar);
        }
        return expanded.toString();
    }

    static {
        RESERVED.set(92);
        RESERVED.set(46);
        RESERVED.set(123);
        RESERVED.set(125);
        RESERVED.set(91);
        RESERVED.set(93);
        RESERVED.set(40);
        RESERVED.set(41);
        RESERVED.set(42);
        RESERVED.set(63);
        RESERVED.set(43);
        RESERVED.set(58);
        RESERVED.set(94);
        RESERVED.set(36);
        RESERVED.set(124);
    }
}

