/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.text;

import java.nio.CharBuffer;
import org.randombits.utils.text.TextBuffer;
import org.randombits.utils.text.TextProcessor;

public class SymbolProcessor
implements TextProcessor {
    @Override
    public boolean canProcess(CharBuffer text) {
        return text.hasRemaining() && this.isSymbol(text.get());
    }

    private boolean isSymbol(char ch) {
        return !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    @Override
    public int compare(CharBuffer text1, CharBuffer text2) {
        TextBuffer s1 = this.getSymbols(text1);
        TextBuffer s2 = this.getSymbols(text2);
        return s1.compareTo(s2);
    }

    private TextBuffer getSymbols(CharBuffer text) {
        TextBuffer out = new TextBuffer();
        while (text.hasRemaining() && this.isSymbol(text.charAt(0))) {
            out.add(text.get());
        }
        if (out.length() == 0) {
            throw new IllegalArgumentException("Expected symbol: " + text);
        }
        return out;
    }
}

