/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.text;

import java.nio.CharBuffer;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.randombits.utils.text.DigitProcessor;
import org.randombits.utils.text.LetterProcessor;
import org.randombits.utils.text.SymbolProcessor;
import org.randombits.utils.text.TextProcessor;

public class TextComparator
implements Comparator<Object> {
    private TextProcessor[] processors;

    public static TextComparator getNaturalInstance() {
        return TextComparator.getNaturalInstance((Collator)null);
    }

    public static TextComparator getNaturalInstance(Locale locale) {
        return TextComparator.getNaturalInstance(locale == null ? null : Collator.getInstance(locale));
    }

    public static TextComparator getNaturalInstance(Collator collator) {
        return new TextComparator(new TextProcessor[]{new SymbolProcessor(), new DigitProcessor(), new LetterProcessor(collator)});
    }

    public TextComparator(TextProcessor[] processors) {
        this.processors = processors;
    }

    @Override
    public int compare(String s1, String s2) {
        CharBuffer cb1 = CharBuffer.wrap(s1 == null ? "" : s1).asReadOnlyBuffer();
        CharBuffer cb2 = CharBuffer.wrap(s2 == null ? "" : s2).asReadOnlyBuffer();
        while (cb1.hasRemaining() && cb2.hasRemaining()) {
            boolean p1 = false;
            boolean p2 = false;
            for (int i = 0; !p1 && !p2 && i < this.processors.length; ++i) {
                TextProcessor processor = this.processors[i];
                p1 = processor.canProcess(cb1.duplicate());
                p2 = processor.canProcess(cb2.duplicate());
                int result = 0;
                if (p1 && p2) {
                    result = processor.compare(cb1, cb2);
                    if (result == 0) continue;
                    return result;
                }
                if (p1) {
                    return -1;
                }
                if (!p2) continue;
                return 1;
            }
            if (p1 || p2) continue;
            return 0;
        }
        if (cb1.hasRemaining()) {
            return 1;
        }
        if (cb2.hasRemaining()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s1 = this.asString(o1);
        String s2 = this.asString(o2);
        return this.compare(s1, s2);
    }

    protected String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }
}

