package org.randombits.support.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import org.randombits.storage.Storage;
import org.randombits.support.core.param.DefaultParameterContext;
import org.randombits.support.core.param.ParameterContext;
import org.randombits.support.core.param.ParameterSource;

/**
 * Provides parameter details for a {@link MacroInfo} instance. {@link ParameterContext}s
 * created by this source will be pre-populated with the current {@link ConversionContext}
 * and {@link ContentEntityObject} from the {@link MacroInfo} instance.
 */
public class MacroInfoParameterSource implements ParameterSource {

    private final Storage params;

    private final MacroInfo info;

    public MacroInfoParameterSource( MacroInfo info ) {
        this.info = info;
        this.params = info.getMacroParams();
    }

    @Override
    public String getValue( String name ) {
        return params.getString( name, null );
    }

    @Override
    public ParameterContext createContext() {
        DefaultParameterContext context = new DefaultParameterContext();
        context.set( ConversionContext.class, info.getConversionContext() );
        context.set( ContentEntityObject.class, info.getContent() );
        return context;
    }

    public Storage getParams() {
        return params;
    }

    public MacroInfo getMacroInfo() {
        return info;
    }
}
