/*
 * Copyright (c) 2006, David Peterson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of "randombits.org" nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.randombits.support.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;

/**
 * @author David Peterson
 */
public interface LinkAssistant {

    /**
     * Parses a content name (e.g. 'SPACE:Page' or 'Page^attachment.ext') and
     * returns the entity it identifies.
     * 
     * @param context
     *            The context to get spaces/content id info from if not
     *            specified in the contentName.
     * @param linkText
     *            The name of the entity being tracked
     * @return The entity matching the name, or <code>null</code> if it could
     *         not be found.
     */
    ConfluenceEntityObject getEntityForWikiLink( ConversionContext context, String linkText );

    /**
     * Generates a wiki link, without any surrounding '[]'s. Eg 'My
     * Page^attachment.ext'.
     * 
     *
     * @param context
     * @param entity
     *            The entity to link to.
     * @return The wiki link text.
     */
    String getWikiLinkForEntity( ConversionContext context, ConfluenceEntityObject entity );

    String getURLForEntity( ConversionContext context, ConfluenceEntityObject ceo );

    String getURLForEntity( ConversionContext context, ConfluenceEntityObject ceo, String anchor );

    String getURLForWikiLink( ConversionContext context, String linkText );

    String getContextPath();

    boolean saveOutgoingLink( ContentEntityObject sourceContent, ConfluenceEntityObject targetContent );

    boolean saveOutgoingLink( ContentEntityObject sourceContent, String spaceKey, String targetPageTitle );

    boolean saveOutgoingLink( ContentEntityObject sourceContent, String url );
}
