/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import javax.servlet.http.HttpServletRequest;
import org.randombits.storage.Storage;
import org.randombits.storage.confluence.ContentPropertyStorage;
import org.randombits.support.confluence.RequestInfo;
import org.randombits.support.core.env.EnvironmentAssistant;

public class PageInfo
extends RequestInfo {
    private static final ThreadLocal<ContentEntityObject> contentContext = new ThreadLocal();
    private ContentEntityObject content;
    private Storage contentProperties;

    public PageInfo(HttpServletRequest req, ContentEntityObject content) {
        super(req);
        this.setContent(content);
    }

    public PageInfo(EnvironmentAssistant environmentAssistant, ContentEntityObject content) {
        super(environmentAssistant);
        this.setContent(content);
    }

    public static ContentEntityObject getCurrentContent() {
        return contentContext.get();
    }

    protected void setContent(ContentEntityObject content) {
        this.content = content;
        contentContext.set(content);
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public Storage getContentProperties() {
        if (this.contentProperties == null && this.content != null) {
            this.contentProperties = new ContentPropertyStorage(this.getContent());
        }
        return this.contentProperties;
    }

    public Space getSpace() {
        ContentEntityObject content = this.getContent();
        if (content instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)content).getSpace();
        }
        return null;
    }

    public User getCurrentUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    @Override
    public void close() {
        super.close();
        if (contentContext.get() == this.content) {
            contentContext.remove();
        }
        this.content = null;
        this.contentProperties = null;
    }
}

