/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence.convert.search;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.search.v2.SearchResult;
import org.randombits.support.core.convert.AbstractConverter;
import org.randombits.support.core.convert.ConversionCost;
import org.randombits.support.core.convert.ConversionException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchResultConverter<T extends ConfluenceEntityObject>
extends AbstractConverter<SearchResult, T> {
    private AnyTypeDao anyTypeDao;
    private final String type;

    public AbstractSearchResultConverter(String type) {
        super(ConversionCost.DATABASE_LOOKUP.and(ConversionCost.CREATE_COMPLEX_OBJECT));
        this.type = type;
    }

    protected boolean supportsSearchResult(SearchResult result) {
        return this.type.equals(result.getType());
    }

    public boolean canConvert(Object source, Class<?> targetType) {
        SearchResult result;
        if (source instanceof SearchResult && this.supportsSearchResult(result = (SearchResult)source)) {
            return super.canConvert(source, targetType);
        }
        return false;
    }

    protected T convert(SearchResult searchResult) throws ConversionException {
        if (this.supportsSearchResult(searchResult)) {
            Object value = this.anyTypeDao.findByHandle(searchResult.getHandle());
            if (this.getTargetType().isInstance(value)) {
                return (T)((ConfluenceEntityObject)this.getTargetType().cast(value));
            }
        }
        return null;
    }

    protected AnyTypeDao getAnyTypeDao() {
        return this.anyTypeDao;
    }

    @Autowired
    public void setAnyTypeDao(AnyTypeDao anyTypeDao) {
        this.anyTypeDao = anyTypeDao;
    }
}

