/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence.render;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.randombits.support.confluence.render.DefaultRenderable;
import org.randombits.support.confluence.render.RenderAssistant;
import org.randombits.support.confluence.render.RenderException;
import org.randombits.support.confluence.render.RenderType;
import org.randombits.support.confluence.render.Renderable;
import org.randombits.support.confluence.util.XhtmlUtils;

public class DefaultRenderAssistant
implements RenderAssistant {
    private final XhtmlContent xhtmlContent;

    public DefaultRenderAssistant(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public String render(String text, RenderType type, ConversionContext conversionContext) throws RenderException {
        return this.render(new DefaultRenderable(text, type, conversionContext));
    }

    @Override
    public String render(Renderable renderable) throws RenderException {
        switch (renderable.getType()) {
            case WIKI: {
                return this.renderWiki(renderable);
            }
            case RICHTEXT: {
                return this.renderRichText(renderable);
            }
        }
        return this.renderPlain(renderable);
    }

    private String renderPlain(Renderable renderable) {
        return HtmlEscaper.escapeAll((String)renderable.getText(), (boolean)false);
    }

    private String renderWiki(Renderable renderable) throws RenderException {
        ArrayList exceptions = new ArrayList();
        try {
            String value = this.xhtmlContent.convertWikiToView(renderable.getText(), renderable.getConversionContext(), exceptions);
            if (!exceptions.isEmpty()) {
                throw new RenderException("Exceptions occurred while rendering wiki markup.", exceptions);
            }
            return XhtmlUtils.stripParagraphWrapper(value);
        }
        catch (XMLStreamException e) {
            throw new RenderException(e.getMessage(), e);
        }
        catch (XhtmlException e) {
            throw new RenderException(e.getMessage(), e);
        }
    }

    private String renderRichText(Renderable renderable) throws RenderException {
        try {
            return XhtmlUtils.stripParagraphWrapper(this.xhtmlContent.convertStorageToView(renderable.getText(), renderable.getConversionContext()));
        }
        catch (XMLStreamException e) {
            throw new RenderException(e.getMessage(), e);
        }
        catch (XhtmlException e) {
            throw new RenderException(e.getMessage(), e);
        }
    }
}

