/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.support.confluence.util;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XhtmlUtils {
    private static Pattern BLANK_PARA = Pattern.compile("(\\s|[\\u00A0]|\\<\\/?[pP]/?\\>)*");
    private static Pattern STRIP_PARA = Pattern.compile("^(?:\\s|[\\u00A0]|\\<\\/?[pP]/?\\>)*(.*?)(?:\\s|[\\u00A0]|\\<\\/?[pP]/?\\>)*$", 32);

    public static boolean isNotBlank(String value) {
        return !XhtmlUtils.isBlank(value);
    }

    public static String stripParagraphWrapper(String xhtmlValue) {
        Matcher matcher = STRIP_PARA.matcher(xhtmlValue);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return xhtmlValue;
    }

    public static boolean isBlank(String value) {
        return value == null || BLANK_PARA.matcher(value).replaceAll("").isEmpty();
    }

    public static void appendAttribute(StringBuilder out, String name, Object value) {
        if (value != null) {
            out.append(" ").append(GeneralUtil.escapeXml((String)name)).append("='").append(GeneralUtil.escapeXml((String)value.toString())).append("'");
        }
    }

    public static void appendStyleParam(StringBuilder out, String name, String value) {
        if (value != null) {
            out.append(GeneralUtil.escapeXml((String)name)).append(": ").append(GeneralUtil.escapeXml((String)value)).append("; ");
        }
    }
}

