/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.collection;

import java.util.BitSet;

public class ABitSet
extends BitSet {
    boolean lockable = false;
    boolean locked = false;

    public ABitSet() {
        this(false);
    }

    public ABitSet(boolean lockable) {
        this.lockable = lockable;
    }

    public ABitSet(int nbits, boolean lockable) {
        super(nbits);
        this.lockable = lockable;
    }

    public boolean isLockable() {
        return this.lockable;
    }

    public void lock() {
        if (!this.lockable) {
            throw new UnsupportedOperationException("This ABitSet is not lockable.");
        }
        this.locked = true;
    }

    public void set(String chars) {
        if (chars != null) {
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                this.set(chars.charAt(i));
            }
        }
    }

    public void set(int[] bits) {
        if (bits != null) {
            for (int bit : bits) {
                this.set(bit);
            }
        }
    }

    public void clear(int[] bits) {
        if (bits != null) {
            for (int bit : bits) {
                this.clear(bit);
            }
        }
    }

    public void clear(String chars) {
        if (chars != null) {
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                this.clear(chars.charAt(i));
            }
        }
    }

    public void setRange(int from, int to) {
        if (from > to) {
            int temp = from;
            from = to;
            to = temp;
        }
        for (int i = to; i >= from; --i) {
            this.set(i);
        }
    }

    public void clearRange(int from, int to) {
        if (to < from) {
            int temp = from;
            from = to;
            to = temp;
        }
        for (int i = from; i <= to; ++i) {
            this.clear(i);
        }
    }

    @Override
    public void set(int bitIndex) {
        this.checkLock();
        super.set(bitIndex);
    }

    @Override
    public void clear(int bitIndex) {
        this.checkLock();
        super.clear(bitIndex);
    }

    private void checkLock() {
        if (this.locked) {
            throw new UnsupportedOperationException("The bit set cannot be modified when locked");
        }
    }
}

