/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.utils.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isIterable(Object value) {
        return value instanceof Iterator || value instanceof Iterable || value instanceof Enumeration || value != null && value.getClass().isArray();
    }

    public static Iterator<?> asIterator(Object value) {
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof Enumeration) {
            return IteratorUtils.asIterator((Enumeration)((Enumeration)value));
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return IteratorUtils.arrayIterator((Object[])((Object[])value));
            }
            return Arrays.asList(value).iterator();
        }
        return IteratorUtils.emptyIterator();
    }

    public static Collection<?> asCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Iterable) {
            return IteratorUtils.toList(((Iterable)value).iterator());
        }
        if (value instanceof Iterator) {
            return IteratorUtils.toList((Iterator)((Iterator)value));
        }
        if (value instanceof Enumeration) {
            return Collections.list((Enumeration)value);
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return Arrays.asList((Object[])value);
            }
            return Arrays.asList(value);
        }
        return Collections.EMPTY_LIST;
    }
}

