/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.client.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.oltu.oauth2.client.response.OAuthClientResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public abstract class OAuthClientValidator {
    protected Map<String, String[]> requiredParams = new HashMap<String, String[]>();
    protected List<String> notAllowedParams = new ArrayList<String>();

    public void validate(OAuthClientResponse response) throws OAuthProblemException {
        this.validateErrorResponse(response);
        this.validateParameters(response);
    }

    public void validateParameters(OAuthClientResponse response) throws OAuthProblemException {
        this.validateRequiredParameters(response);
        this.validateNotAllowedParameters(response);
    }

    public void validateErrorResponse(OAuthClientResponse response) throws OAuthProblemException {
        String error = response.getParam("error");
        if (!OAuthUtils.isEmpty(error)) {
            String errorDesc = response.getParam("error_description");
            String errorUri = response.getParam("error_uri");
            String state = response.getParam("state");
            throw OAuthProblemException.error(error).description(errorDesc).uri(errorUri).state(state);
        }
    }

    public void validateRequiredParameters(OAuthClientResponse response) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (Map.Entry<String, String[]> requiredParam : this.requiredParams.entrySet()) {
            String paramName = requiredParam.getKey();
            String val = response.getParam(paramName);
            if (OAuthUtils.isEmpty(val)) {
                missingParameters.add(paramName);
                continue;
            }
            String[] dependentParams = requiredParam.getValue();
            if (OAuthUtils.hasEmptyValues(dependentParams)) continue;
            for (String dependentParam : dependentParams) {
                val = response.getParam(dependentParam);
                if (!OAuthUtils.isEmpty(val)) continue;
                missingParameters.add(dependentParam);
            }
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    public void validateNotAllowedParameters(OAuthClientResponse response) throws OAuthProblemException {
        ArrayList<String> notAllowedParameters = new ArrayList<String>();
        for (String requiredParam : this.notAllowedParams) {
            String val = response.getParam(requiredParam);
            if (OAuthUtils.isEmpty(val)) continue;
            notAllowedParameters.add(requiredParam);
        }
        if (!notAllowedParameters.isEmpty()) {
            throw OAuthUtils.handleNotAllowedParametersOAuthException(notAllowedParameters);
        }
    }
}

