/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.activity;

import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.util.U;

public abstract class AbstractThreadActivity<T>
extends LifecycleActivity<T>
implements Runnable {
    protected final Thread thread;

    public AbstractThreadActivity(String name) {
        super(name);
        this.thread = new Thread((Runnable)this, name);
    }

    @Override
    public T start() {
        this.checkActive(false);
        this.thread.start();
        return super.start();
    }

    @Override
    public T halt() {
        this.checkActive(true);
        this.thread.stop();
        U.joinThread(this.thread);
        return super.halt();
    }

    @Override
    public T shutdown() {
        this.checkActive(true);
        this.thread.interrupt();
        U.joinThread(this.thread);
        return super.shutdown();
    }

    @Override
    public final void run() {
        U.info("Starting activity thread", "name", this.name);
        try {
            while (!Thread.interrupted()) {
                try {
                    this.loop();
                }
                catch (Exception e) {
                    U.error("Worker processing error!", "activity", this.name, "error", e);
                }
            }
        }
        catch (ThreadDeath e) {
            U.info("Halted activity thread", "name", this.name);
            return;
        }
        U.info("Finished activity thread", "name", this.name);
    }

    protected abstract void loop();
}

