/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rapidoid.app.AppClasses;
import org.rapidoid.app.Apps;
import org.rapidoid.html.Cmd;
import org.rapidoid.html.Tag;
import org.rapidoid.html.tag.ATag;
import org.rapidoid.html.tag.FormTag;
import org.rapidoid.html.tag.UlTag;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.oauth.OAuth;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.pages.BootstrapWidgets;
import org.rapidoid.pages.Pages;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;

public class AppPageGeneric
extends BootstrapWidgets
implements Comparator<Class<?>> {
    private static final String SEARCH_SCREEN = "SearchScreen";
    private static final String SETTINGS_SCREEN = "SettingsScreen";
    private static final String[] themes = new String[]{"default", "cerulean", "cosmo", "cyborg", "darkly", "flatly", "journal", "lumen", "paper", "readable", "sandstone", "simplex", "slate", "spacelab", "superhero", "united", "yeti"};
    private static final String SESSION_CURRENT_SCREEN = "_current_screen_";
    private final AppClasses appCls = Apps.scanAppClasses();
    private final Object app;
    private final Map<String, Class<?>> mainScreens;

    public AppPageGeneric() {
        this.app = this.appCls.main != null ? U.newInstance(this.appCls.main) : new Object();
        this.mainScreens = AppPageGeneric.filterScreens(this.app, this.appCls.screens);
    }

    public String title(HttpExchange x) {
        return Pages.titleOf(x, this.app);
    }

    public Object content(HttpExchange x) {
        int screensN;
        Class<?> screenClass = this.getScreenClass(x);
        if (screenClass == null && x.path().equals("/")) {
            return Pages.contentOf(x, this.app);
        }
        x.sessionSet(SESSION_CURRENT_SCREEN, screenClass.getSimpleName());
        Object screen = U.newInstance(screenClass);
        Pages.load(x, screen);
        int n = screensN = this.mainScreens.containsKey(SEARCH_SCREEN) ? this.mainScreens.size() - 1 : this.mainScreens.size();
        if (this.mainScreens.containsKey(SETTINGS_SCREEN)) {
            --screensN;
        }
        Class[] screens = new Class[screensN];
        int ind = 0;
        for (Map.Entry<String, Class<?>> e : this.mainScreens.entrySet()) {
            if (e.getKey().equals(SEARCH_SCREEN) || e.getKey().equals(SETTINGS_SCREEN)) continue;
            screens[ind++] = e.getValue();
        }
        Arrays.sort(screens, this);
        ATag brand = AppPageGeneric.a(Pages.titleOf(x, this.app)).href("/");
        UlTag dropdownMenu = null;
        if (Apps.config(this.app, "auth", true).booleanValue()) {
            if (x.isLoggedIn()) {
                ATag profile = AppPageGeneric.a_glyph("user", x.user().display, AppPageGeneric.caret());
                ATag settings = Apps.config(this.app, "settings", true) != false ? AppPageGeneric.a_glyph("cog", " Settings").href("/settings") : null;
                ATag logout = AppPageGeneric.a_glyph("log-out", "Logout").href("/_logout");
                dropdownMenu = AppPageGeneric.navbarDropdown(false, profile, settings, logout);
            } else {
                ATag ga = null;
                ATag fb = null;
                ATag li = null;
                ATag gh = null;
                if (Apps.config(this.app, "googleLogin", true).booleanValue()) {
                    ga = AppPageGeneric.a_awesome("google", "Sign in with Google").href(OAuth.getLoginURL(x, OAuthProvider.GOOGLE, null));
                }
                if (Apps.config(this.app, "facebookLogin", true).booleanValue()) {
                    fb = AppPageGeneric.a_awesome("facebook", "Sign in with Facebook").href(OAuth.getLoginURL(x, OAuthProvider.FACEBOOK, null));
                }
                if (Apps.config(this.app, "linkedinLogin", true).booleanValue()) {
                    li = AppPageGeneric.a_awesome("linkedin", "Sign in with LinkedIn").href(OAuth.getLoginURL(x, OAuthProvider.LINKEDIN, null));
                }
                if (Apps.config(this.app, "githubLogin", true).booleanValue()) {
                    gh = AppPageGeneric.a_awesome("github", "Sign in with GitHub").href(OAuth.getLoginURL(x, OAuthProvider.GITHUB, null));
                }
                dropdownMenu = AppPageGeneric.navbarDropdown(false, AppPageGeneric.a_glyph("log-in", "Sign in", AppPageGeneric.caret()), ga, fb, li, gh);
            }
        }
        ATag theme = AppPageGeneric.a_glyph("eye-open", "", AppPageGeneric.caret());
        Object[] themess = new Object[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            String thm = themes[i];
            String js = U.format("document.cookie='THEME=%s; path=/'; location.reload();", thm);
            themess[i] = AppPageGeneric.a(U.capitalized(thm)).onclick(js);
        }
        UlTag themesMenu = Apps.config(this.app, "themes", true) != false ? AppPageGeneric.navbarDropdown(false, theme, themess) : null;
        Object[] menuItems = new Object[screens.length];
        int activeIndex = -1;
        int k = 0;
        for (int i = 0; i < screens.length; ++i) {
            Class scr = screens[i];
            String name = Apps.screenName(scr);
            String title = U.or(this.titleOf(scr), U.camelPhrase(name));
            menuItems[k++] = AppPageGeneric.a(title).href(Apps.screenUrl(scr));
            if (!scr.equals(screenClass)) continue;
            activeIndex = i;
        }
        UlTag navMenu = AppPageGeneric.navbarMenu(true, activeIndex, menuItems);
        FormTag searchForm = null;
        if (Apps.config(this.app, "search", true).booleanValue()) {
            searchForm = (FormTag)((FormTag)AppPageGeneric.navbarForm(false, "Find", AppPageGeneric.arr("q"), AppPageGeneric.arr("Search")).attr("action", "/search")).attr("method", "GET");
        }
        Object[] navbarContent = AppPageGeneric.arr(navMenu, themesMenu, dropdownMenu, searchForm);
        Tag<?> pageContent = Pages.contentOf(x, screen);
        if (pageContent == null) {
            pageContent = AppPageGeneric.hardcoded("No content available!");
        }
        Tag<?> result = AppPageGeneric.navbarPage(this.isFluid(this.app), brand, navbarContent, pageContent);
        Pages.store(x, screen);
        return result;
    }

    private Class<?> getScreenClass(HttpExchange x) {
        String path = x.path();
        Class<?> screenClass = path.startsWith("/_") ? this.appCls.screens.get(x.session(SESSION_CURRENT_SCREEN)) : this.getScreen(path);
        return screenClass;
    }

    protected boolean isFluid(Object app) {
        return Apps.config(app, "fluid", true);
    }

    public String appTitle(Object app) {
        return U.or(this.titleOf(app), "Untitled app");
    }

    private String titleOf(Object obj) {
        return Cls.getFieldValue(obj, "title", null);
    }

    @Override
    public int compare(Class<?> o1, Class<?> o2) {
        int cls1 = this.screenOrder(o1);
        int cls2 = this.screenOrder(o2);
        return cls1 - cls2;
    }

    private int screenOrder(Class<?> scrClass) {
        String cls = scrClass.getSimpleName();
        if (cls.equals("HomeScreen")) {
            return -1000;
        }
        if (cls.equals("AboutScreen")) {
            return 1000;
        }
        if (cls.equals("HelpScreen")) {
            return 2000;
        }
        return cls.charAt(0);
    }

    private Class<?> getScreen(String path) {
        for (Class<?> screen : this.appCls.screens.values()) {
            if (!Apps.screenUrl(screen).equals(path)) continue;
            return screen;
        }
        return null;
    }

    private static Map<String, Class<?>> filterScreens(Object app, Map<String, Class<?>> screenClasses) {
        Object[] screensConfig = Apps.config(app, "screens", null);
        if (screensConfig == null) {
            return screenClasses;
        }
        LinkedHashMap filtered = new LinkedHashMap();
        for (Object scr : screensConfig) {
            if (scr instanceof Class) {
                Class cls = (Class)scr;
                filtered.put(cls.getSimpleName(), screenClasses.get(cls.getSimpleName()));
                continue;
            }
            if (scr instanceof String) {
                String name = U.capitalized((String)scr);
                if (!name.endsWith("Screen")) {
                    name = name + "Screen";
                }
                filtered.put(name, screenClasses.get(name));
                continue;
            }
            throw U.rte("Expected class or string to represent a screen, but found: %s", scr);
        }
        return filtered;
    }

    public void on(HttpExchange x, String cmd, Object[] args) {
        Class<?> screenClass = this.getScreenClass(x);
        U.must(screenClass != null, "Cannot find a screen to process the command!");
        x.sessionSet(SESSION_CURRENT_SCREEN, screenClass.getSimpleName());
        Object screen = U.newInstance(screenClass);
        Pages.load(x, screen);
        Pages.callCmdHandler(x, screen, new Cmd(cmd, args));
        Pages.store(x, screen);
    }
}

