/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.app;

import java.util.Map;
import org.rapidoid.app.AppClasses;
import org.rapidoid.app.AppHandler;
import org.rapidoid.app.TheDefaultApp;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.HttpBuiltins;
import org.rapidoid.oauth.OAuth;
import org.rapidoid.oauth.OAuthProvider;
import org.rapidoid.pages.Pages;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;

public class Apps {
    private static AppClasses APP_CLASSES;

    public static void main(String[] args) {
        U.args(args);
        HTTPServer server = (HTTPServer)HTTP.server().build();
        OAuth.register(server, new OAuthProvider[0]);
        HttpBuiltins.register(server);
        Pages.registerPages(server);
        server.serve(new AppHandler());
        server.start();
    }

    public static String screenName(Class<?> screenClass) {
        return U.mid(screenClass.getSimpleName(), 0, -6);
    }

    public static String screenUrl(Class<?> screenClass) {
        String url = "/" + Apps.screenName(screenClass).toLowerCase();
        return url.equals("/home") ? "/" : url;
    }

    public static AppClasses scanAppClasses() {
        return Apps.scanAppClasses(null);
    }

    public static synchronized AppClasses scanAppClasses(ClassLoader classLoader) {
        if (APP_CLASSES == null) {
            Map<String, Class<?>> services = Cls.classMap(U.classpathClassesBySuffix("Service", null, classLoader));
            Map<String, Class<?>> pages = Cls.classMap(U.classpathClassesBySuffix("Page", null, classLoader));
            Map<String, Class<?>> apps = Cls.classMap(U.classpathClassesByName("App", null, classLoader));
            Map<String, Class<?>> screens = Cls.classMap(U.classpathClassesBySuffix("Screen", null, classLoader));
            Class<TheDefaultApp> appClass = !apps.isEmpty() ? apps.get("App") : TheDefaultApp.class;
            APP_CLASSES = new AppClasses(appClass, services, pages, screens);
        }
        return APP_CLASSES;
    }

    public static <T> T config(Object obj, String configName, T byDefault) {
        T val = Cls.getPropValue(obj, configName, null);
        return val != null ? val : (T)byDefault;
    }
}

