/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.MultiBuf;
import org.rapidoid.pool.ArrayPool;
import org.rapidoid.pool.Pool;

public class BufGroup {
    private final int factor;
    private final int capacity;
    private final Pool<ByteBuffer> pool;

    public BufGroup(int factor) {
        this.factor = factor;
        this.capacity = (int)Math.pow(2.0, factor);
        this.pool = new ArrayPool<ByteBuffer>(new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() {
                return ByteBuffer.allocateDirect(BufGroup.this.capacity);
            }
        }, 1000);
    }

    public Buf newBuf(String name) {
        return new MultiBuf(this.pool, this.factor, name);
    }

    public Buf newBuf() {
        return this.newBuf("no-name");
    }

    public Buf from(String s, String name) {
        return this.from(ByteBuffer.wrap(s.getBytes()), name);
    }

    public Buf from(ByteBuffer bbuf, String name) {
        Buf buf = this.newBuf(name);
        buf.append(bbuf);
        return buf;
    }

    public int instances() {
        return this.pool.instances();
    }
}

