/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufBytes;
import org.rapidoid.bytes.BYTES;
import org.rapidoid.bytes.ByteBufferBytes;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.pool.Pool;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.wrap.Int;

public class MultiBuf
implements Buf,
Constants {
    private final byte[] HELPER = new byte[20];
    private final Range HELPER_RANGE = new Range();
    private static final int TO_BYTES = 1;
    private static final int TO_CHANNEL = 2;
    private static final int TO_BUFFER = 3;
    private final Pool<ByteBuffer> bufPool;
    private final int factor;
    private final int addrMask;
    private final int singleCap;
    private ByteBuffer[] bufs = new ByteBuffer[10];
    private int bufN;
    private int shrinkN;
    private final String name;
    private int _position;
    private int _limit;
    int ccc = Integer.MIN_VALUE;
    int[] cccc = new int[300];
    private OutputStream outputStream;
    private final ByteBufferBytes singleBytes = new ByteBufferBytes();
    private final Bytes multiBytes;
    private Bytes _bytes = this.multiBytes = new BufBytes(this);
    private int _size;

    public MultiBuf(Pool<ByteBuffer> bufPool, int factor, String name) {
        this.bufPool = bufPool;
        this.name = name;
        this.singleCap = (int)Math.pow(2.0, factor);
        this.factor = factor;
        this.addrMask = this.addrMask();
        assert (this.invariant());
    }

    private int addrMask() {
        int mask = 1;
        for (int i = 0; i < this.factor - 1; ++i) {
            mask <<= 1;
            mask |= 1;
        }
        return mask;
    }

    @Override
    public boolean isSingle() {
        assert (this.invariant());
        return this.bufN == 1;
    }

    @Override
    public byte get(int position) {
        assert (this.invariant());
        assert (position >= 0);
        this.validatePos(position, 1);
        ByteBuffer buf = this.bufs[(position += this.shrinkN) >> this.factor];
        assert (buf != null);
        assert (this.invariant());
        return buf.get(position & this.addrMask);
    }

    private void validatePos(int pos, int space) {
        boolean hasEnough;
        if (pos < 0) {
            throw U.rte("Invalid position: " + pos);
        }
        int least = pos + space;
        boolean bl = hasEnough = least <= this._size() && least <= this._limit;
        if (!hasEnough) {
            throw INCOMPLETE_READ;
        }
    }

    @Override
    public void put(int position, byte value) {
        assert (this.invariant());
        assert (position >= 0);
        this.validatePos(position, 1);
        ByteBuffer buf = this.bufs[(position += this.shrinkN) >> this.factor];
        assert (buf != null);
        buf.put(position & this.addrMask, value);
        assert (this.invariant());
    }

    @Override
    public int size() {
        assert (this.invariant());
        assert (this._size == this._size());
        return this._size;
    }

    private int _size() {
        return this.bufN > 0 ? (this.bufN - 1) * this.singleCap + this.bufs[this.bufN - 1].position() - this.shrinkN : 0;
    }

    private void expandUnit() {
        if (this.bufN == this.bufs.length) {
            this.bufs = (ByteBuffer[])U.expand(this.bufs, 2);
        }
        this.bufs[this.bufN] = this.bufPool.get();
        this.bufs[this.bufN].clear();
        ++this.bufN;
    }

    @Override
    public void append(byte value) {
        assert (this.invariant());
        this.writableBuf().put(value);
        this.sizeChanged();
        assert (this.invariant());
    }

    @Override
    public int append(ReadableByteChannel channel) throws IOException {
        int space;
        int read;
        boolean done;
        assert (this.invariant());
        int totalRead = 0;
        do {
            ByteBuffer dest = this.writableBuf();
            space = dest.remaining();
            assert (space > 0);
            read = channel.read(dest);
            if (read >= 0) {
                totalRead += read;
                continue;
            }
            this.removeLastBufferIfEmpty();
            this.sizeChanged();
            assert (this.invariant());
            return -1;
        } while (!(done = read < space));
        this.removeLastBufferIfEmpty();
        this.sizeChanged();
        assert (this.invariant());
        return totalRead;
    }

    @Override
    public void append(ByteBuffer src) {
        assert (this.invariant());
        int theLimit = src.limit();
        while (src.hasRemaining()) {
            ByteBuffer dest = this.writableBuf();
            int space = dest.remaining();
            assert (space > 0);
            if (src.remaining() > space) {
                src.limit(src.position() + space);
            }
            dest.put(src);
            src.limit(theLimit);
        }
        this.sizeChanged();
        assert (this.invariant());
    }

    @Override
    public void append(byte[] src, int offset, int length) {
        assert (this.invariant());
        int sizeBefore = this._size();
        if (length > 0) {
            ByteBuffer buf = this.writableBuf();
            if (length <= buf.remaining()) {
                buf.put(src, offset, length);
            } else {
                int partLen = buf.remaining();
                buf.put(src, offset, partLen);
                assert (buf.remaining() == 0);
                this.append(src, offset + partLen, length - partLen);
            }
        }
        this.sizeChanged();
        assert (this._size() - sizeBefore == length);
        assert (this.invariant());
    }

    private ByteBuffer writableBuf() {
        if (this.bufN == 0) {
            this.expandUnit();
            return this.last();
        }
        ByteBuffer cbuf = this.last();
        if (!cbuf.hasRemaining()) {
            this.expandUnit();
            cbuf = this.last();
        }
        assert (cbuf.hasRemaining());
        return cbuf;
    }

    private ByteBuffer last() {
        assert (this.bufN > 0);
        return this.bufs[this.bufN - 1];
    }

    @Override
    public ByteBuffer first() {
        assert (this.invariant());
        assert (this.bufN > 0);
        return this.bufs[0];
    }

    @Override
    public ByteBuffer bufAt(int index) {
        assert (this.invariant());
        assert (this.bufN > index);
        return this.bufs[index];
    }

    @Override
    public int append(String s) {
        assert (this.invariant());
        byte[] bytes = s.getBytes();
        this.append(bytes);
        this.sizeChanged();
        assert (this.invariant());
        return bytes.length;
    }

    public String toString() {
        return String.format("Buf " + this.name + " [size=" + this._size() + ", units=" + this.unitCount() + ", trash=" + this.shrinkN + ", pos=" + this.position() + ", limit=" + this.limit() + "] " + super.toString(), new Object[0]);
    }

    @Override
    public String data() {
        assert (this.invariant());
        byte[] bytes = new byte[this._size()];
        int total = this.readAll(bytes, 0, 0, bytes.length);
        assert (total == bytes.length);
        assert (this.invariant());
        return new String(bytes);
    }

    @Override
    public String get(Range range) {
        assert (this.invariant());
        if (range.isEmpty()) {
            return "";
        }
        byte[] bytes = new byte[range.length];
        int total = this.readAll(bytes, 0, range.start, range.length);
        assert (total == bytes.length);
        assert (this.invariant());
        return new String(bytes);
    }

    @Override
    public void get(Range range, byte[] dest, int offset) {
        assert (this.invariant());
        int total = this.readAll(dest, offset, range.start, range.length);
        assert (total == range.length);
        assert (this.invariant());
    }

    private int writeToHelper(Range range) {
        assert (this.invariant());
        return this.readAll(this.HELPER, 0, range.start, range.length);
    }

    private int readAll(byte[] bytes, int destOffset, int offset, int length) {
        int wrote;
        assert (this.invariant());
        if (offset + length > this._size()) {
            throw new IllegalArgumentException("offset + length > buffer size!");
        }
        try {
            wrote = this.writeTo(1, offset, length, bytes, null, null, destOffset);
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        assert (this.invariant());
        return wrote;
    }

    @Override
    public int writeTo(WritableByteChannel channel) throws IOException {
        assert (this.invariant());
        int wrote = this.writeTo(2, 0, this._size(), null, channel, null, 0);
        assert (U.must(wrote <= this._size(), "Incorrect write to channel!"));
        assert (this.invariant());
        return wrote;
    }

    @Override
    public int writeTo(ByteBuffer buffer) {
        assert (this.invariant());
        try {
            int wrote = this.writeTo(3, 0, this._size(), null, null, buffer, 0);
            assert (wrote == this._size());
            assert (this.invariant());
            return wrote;
        }
        catch (IOException e) {
            assert (this.invariant());
            throw U.rte(e);
        }
    }

    private int writeTo(int mode, int offset, int length, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, int destOffset) throws IOException {
        if (this._size() == 0) {
            assert (length == 0);
            return 0;
        }
        int fromPos = offset + this.shrinkN;
        int toPos = fromPos + length - 1;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (fromInd <= toInd);
        if (fromInd == toInd) {
            return this.writePart(this.bufs[fromInd], fromAddr, toAddr + 1, mode, bytes, channel, buffer, destOffset, -1);
        }
        return this.multiWriteTo(mode, fromInd, toInd, fromAddr, toAddr, bytes, channel, buffer, destOffset);
    }

    private int multiWriteTo(int mode, int fromIndex, int toIndex, int fromAddr, int toAddr, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, int destOffset) throws IOException {
        ByteBuffer first = this.bufs[fromIndex];
        int len = this.singleCap - fromAddr;
        int wrote = this.writePart(first, fromAddr, this.singleCap, mode, bytes, channel, buffer, destOffset, len);
        if (wrote == 0) {
            return 0;
        }
        int wroteTotal = wrote;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            wrote = this.writePart(this.bufs[i], 0, this.singleCap, mode, bytes, channel, buffer, destOffset + wroteTotal, this.singleCap);
            if (wrote == 0) {
                return wroteTotal;
            }
            wroteTotal += wrote;
        }
        ByteBuffer last = this.bufs[toIndex];
        wroteTotal += this.writePart(last, 0, toAddr + 1, mode, bytes, channel, buffer, destOffset + wroteTotal, toAddr + 1);
        return wroteTotal;
    }

    private int writePart(ByteBuffer src, int pos, int limit, int mode, byte[] bytes, WritableByteChannel channel, ByteBuffer buffer, int destOffset, int len) throws IOException {
        int count;
        int posBackup = src.position();
        int limitBackup = src.limit();
        src.position(pos);
        src.limit(limit);
        assert (src.remaining() == len || len < 0);
        block0 : switch (mode) {
            case 1: {
                if (len >= 0) {
                    src.get(bytes, destOffset, len);
                    count = len;
                    break;
                }
                count = src.remaining();
                src.get(bytes, destOffset, count);
                break;
            }
            case 2: {
                count = 0;
                while (src.hasRemaining()) {
                    int wrote = channel.write(src);
                    count += wrote;
                    if (wrote != 0) continue;
                    break block0;
                }
                break;
            }
            case 3: {
                count = src.remaining();
                buffer.put(src);
                break;
            }
            default: {
                throw U.notExpected();
            }
        }
        src.limit(limitBackup);
        src.position(posBackup);
        return count;
    }

    private boolean invariant() {
        try {
            assert (this.bufN >= 0);
            for (int i = 0; i < this.bufN - 1; ++i) {
                ByteBuffer buf = this.bufs[i];
                assert (buf.position() == this.singleCap);
                assert (buf.limit() == this.singleCap);
                assert (buf.capacity() == this.singleCap);
            }
            if (this.bufN > 0) {
                ByteBuffer buf = this.bufs[this.bufN - 1];
                assert (buf == this.last());
                assert (buf.position() > 0);
                assert (buf.capacity() == this.singleCap);
            }
            return true;
        }
        catch (AssertionError e) {
            this.dumpBuffers();
            throw e;
        }
    }

    private void dumpBuffers() {
        U.print(">> BUFFER " + this.name + " HAS " + this.bufN + " PARTS:");
        for (int i = 0; i < this.bufN - 1; ++i) {
            ByteBuffer buf = this.bufs[i];
            U.show(i + "]" + buf);
        }
        if (this.bufN > 0) {
            ByteBuffer buf = this.bufs[this.bufN - 1];
            U.show("LAST]" + buf);
        }
    }

    @Override
    public void deleteBefore(int count) {
        assert (this.invariant());
        if (count == this._size()) {
            this.clear();
            return;
        }
        this.shrinkN += count;
        while (this.shrinkN >= this.singleCap) {
            this.removeFirstBuf();
            this.shrinkN -= this.singleCap;
        }
        this._position -= count;
        if (this._position < 0) {
            this._position = 0;
        }
        this.sizeChanged();
        assert (this.invariant());
    }

    private void removeFirstBuf() {
        this.bufs[0].clear();
        this.bufPool.release(this.bufs[0]);
        for (int i = 0; i < this.bufN - 1; ++i) {
            this.bufs[i] = this.bufs[i + 1];
        }
        --this.bufN;
    }

    private void removeLastBuf() {
        this.bufs[this.bufN - 1].clear();
        this.bufPool.release(this.bufs[this.bufN - 1]);
        --this.bufN;
        if (this.bufN == 0) {
            this.shrinkN = 0;
        }
    }

    private void removeLastBufferIfEmpty() {
        if (this.bufN > 0 && this.last().position() == 0) {
            this.removeLastBuf();
        }
    }

    @Override
    public int unitCount() {
        assert (this.invariant());
        return this.bufN;
    }

    @Override
    public int unitSize() {
        assert (this.invariant());
        return this.singleCap;
    }

    @Override
    public void put(int position, byte[] bytes, int offset, int length) {
        assert (this.invariant());
        int pos = position;
        for (int i = offset; i < offset + length; ++i) {
            this.put(pos++, bytes[i]);
        }
        assert (this.invariant());
    }

    @Override
    public void append(byte[] bytes) {
        assert (this.invariant());
        this.append(bytes, 0, bytes.length);
        assert (this.invariant());
    }

    @Override
    public void deleteAfter(int position) {
        assert (this.invariant());
        if (this.bufN == 0 || position == this._size()) {
            assert (this.invariant());
            return;
        }
        assert (this.validPosition(position));
        if (this.bufN == 1) {
            int newPos = position + this.shrinkN;
            assert (newPos <= this.singleCap);
            this.first().position(newPos);
            if (newPos == 0) {
                this.removeLastBuf();
            }
        } else {
            int index = (position += this.shrinkN) >> this.factor;
            int addr = position & this.addrMask;
            while (index < this.bufN - 1) {
                this.removeLastBuf();
            }
            ByteBuffer last = this.bufs[index];
            assert (this.last() == last);
            if (addr > 0) {
                last.position(addr);
            } else {
                this.removeLastBuf();
                if (this.bufN > 0) {
                    this.last().position(this.singleCap);
                }
            }
        }
        this.removeLastBufferIfEmpty();
        this.sizeChanged();
        assert (this.invariant());
    }

    @Override
    public void deleteLast(int count) {
        assert (this.invariant());
        this.deleteAfter(this._size() - count);
        assert (this.invariant());
    }

    private boolean validPosition(int position) {
        assert (U.must(position >= 0 && position < this._size(), "Invalid position: %s", position));
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bufN; ++i) {
            this.bufs[i].clear();
            this.bufPool.release(this.bufs[i]);
        }
        this.shrinkN = 0;
        this.bufN = 0;
        this._position = 0;
        this.sizeChanged();
        assert (this.invariant());
    }

    @Override
    public long getN(Range range) {
        int start;
        assert (this.invariant());
        assert (range.length >= 1);
        if (range.length > 20) {
            assert (this.invariant());
            throw U.rte("Too many digits!");
        }
        int count = this.writeToHelper(range);
        int value = 0;
        boolean negative = this.HELPER[0] == 45;
        for (int i = start = negative ? 1 : 0; i < count; ++i) {
            byte b = this.HELPER[i];
            if (b < 48 || b > 57) {
                assert (this.invariant());
                throw U.rte("Invalid number!");
            }
            int digit = b - 48;
            value = value * 10 + digit;
        }
        assert (this.invariant());
        return negative ? (long)(-value) : (long)value;
    }

    @Override
    public ByteBuffer getSingle() {
        assert (this.invariant());
        return this.isSingle() ? this.first() : null;
    }

    @Override
    public int putNumAsText(int position, long n, boolean forward) {
        int space;
        int direction;
        assert (this.invariant());
        int n2 = direction = forward ? 0 : -1;
        if (n >= 0L) {
            if (n < 10L) {
                this.put(position, (byte)(n + 48L));
                space = 1;
            } else if (n < 100L) {
                long dig1 = n / 10L;
                long dig2 = n % 10L;
                this.put(position + direction, (byte)(dig1 + 48L));
                this.put(position + direction + 1, (byte)(dig2 + 48L));
                space = 2;
            } else {
                int digitsN = (int)Math.ceil(Math.log10(n + 1L));
                int pos = position + digitsN - 1 + direction * digitsN;
                if (!forward) {
                    // empty if block
                }
                while (true) {
                    long digit = n % 10L;
                    byte dig = (byte)(digit + 48L);
                    int n3 = ++pos;
                    --pos;
                    this.put(n3, dig);
                    if (n < 10L) break;
                    n /= 10L;
                }
                space = digitsN;
            }
        } else if (forward) {
            this.put(position, (byte)45);
            space = this.putNumAsText(position + 1, -n, forward) + 1;
        } else {
            int digits = this.putNumAsText(position, -n, forward);
            this.put(position - digits, (byte)45);
            space = digits + 1;
        }
        assert (this.invariant());
        return space;
    }

    private int rebase(int pos, int bufInd) {
        return (bufInd << this.factor) + pos - this.shrinkN;
    }

    @Override
    public byte next() {
        assert (this.invariant());
        byte b = this.get(this._position++);
        assert (this.invariant());
        return b;
    }

    @Override
    public void back(int count) {
        assert (this.invariant());
        --this._position;
        assert (this.invariant());
    }

    @Override
    public byte peek() {
        assert (this.invariant());
        byte b = this.get(this._position);
        assert (this.invariant());
        return b;
    }

    @Override
    public boolean hasRemaining() {
        boolean result;
        assert (this.invariant());
        boolean bl = result = this.remaining() > 0;
        assert (this.invariant());
        return result;
    }

    @Override
    public int remaining() {
        assert (this.invariant());
        return this._limit - this._position;
    }

    @Override
    public int position() {
        assert (this.invariant());
        return this._position;
    }

    @Override
    public int limit() {
        assert (this.invariant());
        return this._limit;
    }

    private void sizeChanged() {
        this._size = this._size();
        this._limit = this._size();
        if (this.bufN == 1) {
            this.singleBytes.setBuf(this.bufs[0]);
            this._bytes = this.singleBytes;
        } else {
            this._bytes = this.multiBytes;
        }
    }

    @Override
    public void position(int position) {
        assert (this.invariant());
        this._position = position;
        assert (this.invariant());
    }

    @Override
    public void limit(int limit) {
        assert (this.invariant());
        this._limit = limit;
        assert (this.invariant());
    }

    @Override
    public void upto(byte value, Range range) {
        assert (this.invariant());
        range.starts(this._position);
        while (this.get(this._position) != value) {
            ++this._position;
        }
        range.ends(this._position);
        ++this._position;
        assert (this.invariant());
    }

    @Override
    public ByteBuffer exposed() {
        assert (this.invariant());
        ByteBuffer first = this.first();
        assert (this.invariant());
        return first;
    }

    @Override
    public void scanUntil(byte value, Range range) {
        byte b;
        int pos;
        assert (this.invariant());
        this.requireRemaining(1);
        int start = this.position();
        int limit = this.limit();
        int last = limit - 1;
        int fromPos = start + this.shrinkN;
        int toPos = last + this.shrinkN;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (U.must(fromInd >= 0, "bad start: %s", start));
        assert (U.must(toInd >= 0, "bad end: %s", last));
        ByteBuffer src = this.bufs[fromInd];
        int absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b == value) {
                range.setInterval(start, absPos);
                this.position(absPos + 1);
                assert (this.invariant());
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1);
                    assert (this.invariant());
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b == value) {
                    range.setInterval(start, absPos);
                    this.position(absPos + 1);
                    assert (this.invariant());
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant());
        throw INCOMPLETE_READ;
    }

    @Override
    public void scanWhile(byte value, Range range) {
        byte b;
        int pos;
        assert (this.invariant());
        this.requireRemaining(1);
        int start = this.position();
        int limit = this.limit();
        int last = limit - 1;
        int fromPos = start + this.shrinkN;
        int toPos = last + this.shrinkN;
        int fromInd = fromPos >> this.factor;
        int toInd = toPos >> this.factor;
        int fromAddr = fromPos & this.addrMask;
        int toAddr = toPos & this.addrMask;
        assert (U.must(fromInd >= 0, "bad start: %s", start));
        assert (U.must(toInd >= 0, "bad end: %s", last));
        ByteBuffer src = this.bufs[fromInd];
        int absPos = start;
        for (pos = fromAddr; pos < this.singleCap; ++pos) {
            b = src.get(pos);
            if (b != value) {
                range.setInterval(start, absPos);
                this.position(absPos);
                assert (this.invariant());
                return;
            }
            ++absPos;
        }
        for (int i = fromInd + 1; i < toInd; ++i) {
            src = this.bufs[i];
            for (int pos2 = 0; pos2 < this.singleCap; ++pos2) {
                byte b2 = src.get(pos2);
                if (b2 != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant());
                    return;
                }
                ++absPos;
            }
        }
        if (fromInd < toInd) {
            src = this.bufs[toInd];
            for (pos = 0; pos <= toAddr; ++pos) {
                b = src.get(pos);
                if (b != value) {
                    range.setInterval(start, absPos);
                    this.position(absPos);
                    assert (this.invariant());
                    return;
                }
                ++absPos;
            }
        }
        this.position(limit);
        assert (this.invariant());
        throw INCOMPLETE_READ;
    }

    private void requireRemaining(int n) {
        if (this.remaining() < n) {
            throw Buf.INCOMPLETE_READ;
        }
    }

    @Override
    public void skip(int count) {
        assert (this.invariant());
        this.requireRemaining(count);
        this._position += count;
        assert (this.invariant());
    }

    @Override
    public int bufferIndexOf(int position) {
        assert (this.invariant());
        assert (position >= 0);
        this.validatePos(position, 1);
        int index = (position += this.shrinkN) >> this.factor;
        assert (this.bufs[index] != null);
        assert (this.invariant());
        return index;
    }

    @Override
    public int bufferOffsetOf(int position) {
        assert (this.invariant());
        assert (position >= 0);
        this.validatePos(position, 1);
        position += this.shrinkN;
        assert (this.invariant());
        return position & this.addrMask;
    }

    @Override
    public int bufCount() {
        assert (this.invariant());
        return this.bufN;
    }

    @Override
    public OutputStream asOutputStream() {
        assert (this.invariant());
        if (this.outputStream == null) {
            this.outputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    MultiBuf.this.append((byte)b);
                }
            };
        }
        assert (this.invariant());
        return this.outputStream;
    }

    @Override
    public String asText() {
        return this.get(new Range(0, this.size()));
    }

    @Override
    public Bytes bytes() {
        assert (this.invariant());
        return this._bytes;
    }

    @Override
    public void scanLn(Range line) {
        assert (this.invariant());
        int pos = BYTES.parseLine(this.bytes(), line, this.position(), this.size());
        if (pos < 0) {
            assert (this.invariant());
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant());
    }

    @Override
    public void scanLnLn(Ranges lines) {
        assert (this.invariant());
        int pos = BYTES.parseLines(this.bytes(), lines, this.position(), this.size());
        if (pos < 0) {
            assert (this.invariant());
            throw INCOMPLETE_READ;
        }
        this._position = pos;
        assert (this.invariant());
    }

    @Override
    public void scanN(int count, Range range) {
        assert (this.invariant());
        this.get(this._position + count - 1);
        range.set(this._position, count);
        this._position += count;
        assert (this.invariant());
    }

    @Override
    public String readLn() {
        assert (this.invariant());
        this.scanLn(this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant());
        return result;
    }

    @Override
    public String readN(int count) {
        assert (this.invariant());
        this.scanN(count, this.HELPER_RANGE);
        String result = this.get(this.HELPER_RANGE);
        assert (this.invariant());
        return result;
    }

    @Override
    public void scanTo(byte sep, Range range, boolean failOnLimit) {
        assert (this.invariant());
        int pos = BYTES.find(this.bytes(), this._position, this._limit, sep, true);
        if (pos >= 0) {
            this.consumeAndSkip(pos, range, 1);
        } else {
            if (failOnLimit) {
                assert (this.invariant());
                throw INCOMPLETE_READ;
            }
            this.consumeAndSkip(this._limit, range, 0);
        }
        assert (this.invariant());
    }

    @Override
    public int scanTo(byte sep1, byte sep2, Range range, boolean failOnLimit) {
        boolean found2;
        assert (this.invariant());
        int pos1 = BYTES.find(this.bytes(), this._position, this._limit, sep1, true);
        int pos2 = BYTES.find(this.bytes(), this._position, this._limit, sep2, true);
        boolean found1 = pos1 >= 0;
        boolean bl = found2 = pos2 >= 0;
        if (found1 && found2) {
            if (pos1 <= pos2) {
                this.consumeAndSkip(pos1, range, 1);
                assert (this.invariant());
                return 1;
            }
            this.consumeAndSkip(pos2, range, 1);
            assert (this.invariant());
            return 2;
        }
        if (found1 && !found2) {
            this.consumeAndSkip(pos1, range, 1);
            assert (this.invariant());
            return 1;
        }
        if (!found1 && found2) {
            this.consumeAndSkip(pos2, range, 1);
            assert (this.invariant());
            return 2;
        }
        if (failOnLimit) {
            assert (this.invariant());
            throw INCOMPLETE_READ;
        }
        this.consumeAndSkip(this._limit, range, 0);
        assert (this.invariant());
        return 0;
    }

    private void consumeAndSkip(int toPos, Range range, int skip) {
        range.setInterval(this._position, toPos);
        this._position = toPos + skip;
    }

    @Override
    public void scanLnLn(Ranges ranges, Int result, byte end1, byte end2) {
        assert (this.invariant());
        int nextPos = BYTES.parseLines(this.bytes(), ranges, result, this._position, this._limit, end1, end2);
        if (nextPos < 0) {
            throw Buf.INCOMPLETE_READ;
        }
        this._position = nextPos;
        assert (this.invariant());
    }
}

