/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.compile.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.rapidoid.compile.CodeDiagnostic;
import org.rapidoid.compile.Compilation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.CustomizableClassLoader;
import org.rapidoid.util.U;

public class EcjCompilation
implements Compilation {
    private final Map<String, byte[]> classes = U.map();
    private final List<CodeDiagnostic> errors = U.list(new Object[0]);
    private final List<CodeDiagnostic> warnings = U.list(new Object[0]);
    private final CustomizableClassLoader loader;

    public EcjCompilation(Predicate<String> allowed) {
        this.loader = new CustomizableClassLoader(U.mapper(this.classes), allowed, false);
    }

    public EcjCompilation() {
        this(Predicate.ALWAYS_TRUE);
    }

    @Override
    public Class<?> loadClass(String fullClassName) throws ClassNotFoundException {
        return this.loader.loadClass(fullClassName);
    }

    @Override
    public Set<Class<?>> loadClasses() throws ClassNotFoundException {
        Set<Object> loadedClasses = U.set(new Object[0]);
        for (String className : this.classes.keySet()) {
            loadedClasses.add(this.loadClass(className));
        }
        return loadedClasses;
    }

    @Override
    public Set<String> getClassNames() {
        return this.classes.keySet();
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public List<CodeDiagnostic> getErrors() {
        return this.errors;
    }

    @Override
    public List<CodeDiagnostic> getWarnings() {
        return this.warnings;
    }

    private static CodeDiagnostic diagnostic(CategorizedProblem problem) {
        CodeDiagnostic diagnostic = new CodeDiagnostic();
        diagnostic.message = problem.getMessage();
        diagnostic.filename = new String(problem.getOriginatingFileName());
        diagnostic.line = problem.getSourceLineNumber();
        diagnostic.start = problem.getSourceStart();
        diagnostic.end = problem.getSourceEnd();
        return diagnostic;
    }

    public String toString() {
        return "EcjCompilation [classes=" + this.classes.keySet() + ", errors=" + this.errors + ", warnings=" + this.warnings + "]";
    }

    public void addResult(CompilationResult result) {
        for (ClassFile cls : result.getClassFiles()) {
            this.classes.put(U.join(".", cls.getCompoundName()), cls.getBytes());
        }
        CategorizedProblem[] problems = result.getAllProblems();
        if (problems != null) {
            for (CategorizedProblem problem : problems) {
                if (problem.isError()) {
                    this.errors.add(EcjCompilation.diagnostic(problem));
                    continue;
                }
                if (problem.isWarning()) {
                    this.warnings.add(EcjCompilation.diagnostic(problem));
                    continue;
                }
                U.warn("Unknown problem type!", "problem", problem);
            }
        }
    }
}

